/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.ConvertUtils;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractConverter<D>
implements Converter<D> {
    private static final String DEFAULT_CONFIG_MSG = "(Converters can be configured to use default values to avoid throwing exceptions)";
    private static final String PACKAGE = "org.apache.commons.beanutils2.converters.";
    private transient Log log;
    private boolean useDefault;
    private D defaultValue;

    protected static String toLowerCase(Object value) {
        return AbstractConverter.toString(value).toLowerCase(Locale.ROOT);
    }

    protected static String toString(Object value) {
        return Objects.requireNonNull(value, "value").toString();
    }

    protected static String toTrim(Object value) {
        return AbstractConverter.toString(value).trim();
    }

    public AbstractConverter() {
    }

    public AbstractConverter(D defaultValue) {
        this.setDefaultValue(defaultValue);
    }

    protected ConversionException conversionException(Class<?> type, Object value) {
        return ConversionException.format("Can't convert value '%s' to type %s", value, type);
    }

    @Override
    public <R> R convert(Class<R> type, Object value) {
        if (type == null) {
            return (R)this.convertToDefaultType(value);
        }
        Class<?> sourceType = value == null ? null : value.getClass();
        Class<R> targetType = ConvertUtils.primitiveToWrapper(type);
        if (this.log().isDebugEnabled()) {
            this.log().debug("Converting" + (value == null ? "" : " '" + this.toString(sourceType) + "'") + " value '" + value + "' to type '" + this.toString(targetType) + "'");
        }
        if ((value = this.convertArray(value)) == null) {
            return this.handleMissing(targetType);
        }
        sourceType = value.getClass();
        try {
            if (targetType.equals(String.class)) {
                return targetType.cast(this.convertToString(value));
            }
            if (targetType.equals(sourceType)) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("    No conversion required, value is already a " + this.toString(targetType));
                }
                return targetType.cast(value);
            }
            R result = this.convertToType(targetType, value);
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Converted to " + this.toString(targetType) + " value '" + result + "'");
            }
            return targetType.cast(result);
        }
        catch (Throwable t) {
            return this.handleError(targetType, value, t);
        }
    }

    protected Object convertArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (Array.getLength(value) > 0) {
                return Array.get(value, 0);
            }
            return null;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (!collection.isEmpty()) {
                return collection.iterator().next();
            }
            return null;
        }
        return value;
    }

    private <T> T convertToDefaultType(Object value) {
        return (T)this.convert(this.getDefaultType(), value);
    }

    protected String convertToString(Object value) {
        return value.toString();
    }

    protected abstract <R> R convertToType(Class<R> var1, Object var2) throws Throwable;

    protected Object getDefault(Class<?> type) {
        if (type.equals(String.class)) {
            return null;
        }
        return this.defaultValue;
    }

    protected abstract Class<D> getDefaultType();

    protected <T> T handleError(Class<T> type, Object value, Throwable cause) {
        if (this.log().isDebugEnabled()) {
            if (cause instanceof ConversionException) {
                this.log().debug("    Conversion threw ConversionException: " + cause.getMessage());
            } else {
                this.log().debug("    Conversion threw " + cause);
            }
        }
        if (this.useDefault) {
            return this.handleMissing(type);
        }
        ConversionException cex = null;
        if (cause instanceof ConversionException) {
            cex = (ConversionException)cause;
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Re-throwing ConversionException: " + cex.getMessage());
                this.log().debug("    (Converters can be configured to use default values to avoid throwing exceptions)");
            }
        } else {
            String msg = "Error converting from '" + this.toString(value.getClass()) + "' to '" + this.toString(type) + "' " + cause.getMessage();
            cex = new ConversionException(msg, cause);
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Throwing ConversionException: " + msg);
                this.log().debug("    (Converters can be configured to use default values to avoid throwing exceptions)");
            }
        }
        throw cex;
    }

    protected <T> T handleMissing(Class<T> type) {
        if (this.useDefault || type.equals(String.class)) {
            Object value = this.getDefault(type);
            if (this.useDefault && value != null && !type.equals(value.getClass())) {
                try {
                    value = this.convertToType(type, this.defaultValue);
                }
                catch (Throwable t) {
                    throw new ConversionException("Default conversion to " + this.toString(type) + " failed.", t);
                }
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Using default " + (value == null ? "" : this.toString(value.getClass()) + " ") + "value '" + this.defaultValue + "'");
            }
            return type.cast(value);
        }
        ConversionException cex = ConversionException.format("No value specified for '%s'", this.toString(type));
        if (this.log().isDebugEnabled()) {
            this.log().debug("    Throwing ConversionException: " + cex.getMessage());
            this.log().debug("    (Converters can be configured to use default values to avoid throwing exceptions)");
        }
        throw cex;
    }

    public boolean isUseDefault() {
        return this.useDefault;
    }

    Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog(this.getClass());
        }
        return this.log;
    }

    protected void setDefaultValue(D defaultValue) {
        this.useDefault = false;
        if (this.log().isDebugEnabled()) {
            this.log().debug("Setting default value: " + defaultValue);
        }
        this.defaultValue = defaultValue == null ? null : this.convert(this.getDefaultType(), defaultValue);
        this.useDefault = true;
    }

    public String toString() {
        return this.toString(this.getClass()) + "[UseDefault=" + this.useDefault + "]";
    }

    String toString(Class<?> type) {
        String typeName = null;
        if (type == null) {
            typeName = "null";
        } else if (type.isArray()) {
            Class<?> elementType = type.getComponentType();
            int count = 1;
            while (elementType.isArray()) {
                elementType = elementType.getComponentType();
                ++count;
            }
            StringBuilder typeNameBuilder = new StringBuilder(elementType.getName());
            for (int i = 0; i < count; ++i) {
                typeNameBuilder.append("[]");
            }
            typeName = typeNameBuilder.toString();
        } else {
            typeName = type.getName();
        }
        if (typeName.startsWith("java.lang.") || typeName.startsWith("java.util.") || typeName.startsWith("java.math.")) {
            typeName = typeName.substring("java.lang.".length());
        } else if (typeName.startsWith(PACKAGE)) {
            typeName = typeName.substring(PACKAGE.length());
        }
        return typeName;
    }
}

