/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.beanutils2.BeanIntrospector;
import org.apache.commons.beanutils2.IntrospectionContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FluentPropertyBeanIntrospector
implements BeanIntrospector {
    public static final String DEFAULT_WRITE_METHOD_PREFIX = "set";
    private final Log log = LogFactory.getLog(this.getClass());
    private final String writeMethodPrefix;

    public FluentPropertyBeanIntrospector() {
        this(DEFAULT_WRITE_METHOD_PREFIX);
    }

    public FluentPropertyBeanIntrospector(String writePrefix) {
        this.writeMethodPrefix = Objects.requireNonNull(writePrefix, "writePrefix");
    }

    private PropertyDescriptor createFluentPropertyDescritor(Method m, String propertyName) throws IntrospectionException {
        return new PropertyDescriptor(this.propertyName(m), null, m);
    }

    public String getWriteMethodPrefix() {
        return this.writeMethodPrefix;
    }

    @Override
    public void introspect(IntrospectionContext icontext) throws IntrospectionException {
        for (Method m : icontext.getTargetClass().getMethods()) {
            if (!m.getName().startsWith(this.getWriteMethodPrefix())) continue;
            String propertyName = this.propertyName(m);
            PropertyDescriptor pd = icontext.getPropertyDescriptor(propertyName);
            try {
                if (pd == null) {
                    icontext.addPropertyDescriptor(this.createFluentPropertyDescritor(m, propertyName));
                    continue;
                }
                if (pd.getWriteMethod() != null) continue;
                PropertyDescriptor fluentPropertyDescriptor = new PropertyDescriptor(pd.getName(), pd.getReadMethod(), m);
                icontext.addPropertyDescriptor(fluentPropertyDescriptor);
            }
            catch (IntrospectionException e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Error when creating PropertyDescriptor for " + m + "! Ignoring this property.", e);
            }
        }
    }

    private String propertyName(Method m) {
        String methodName = m.getName().substring(this.getWriteMethodPrefix().length());
        return methodName.length() > 1 ? Introspector.decapitalize(methodName) : methodName.toLowerCase(Locale.ROOT);
    }
}

