/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.remote;

import io.codeclou.advanced.codeblock.macro.constants.AppConstants;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedHttpException;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedIOException;
import io.codeclou.advanced.codeblock.macro.helper.Base64Helper;
import io.codeclou.advanced.codeblock.macro.helper.Base64Inner;
import io.codeclou.advanced.codeblock.macro.remote.ChunkedTransferSafeInputStreamReader;
import io.codeclou.advanced.codeblock.macro.remote.model.FileSizeCheckResult;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.function.Function;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.util.Timeout;

public class HttpDownloaderHelper {
    public static final String EXTRA_MESSAGE_NEWLINE = "\n";

    public static String getBase64HeaderNullSafe(Base64Helper base64Helper, String username, String password) {
        String auth = username + ":" + password;
        String authEncoded = base64Helper.encodeStringBase64OrNull(auth);
        if (authEncoded != null) {
            return "Basic " + authEncoded;
        }
        return null;
    }

    public static String getExtraInfoFromResponseHeadersAndStatusLine(HttpResponse response, String httpMethod) {
        StringBuilder headers = new StringBuilder();
        if (response != null) {
            try {
                headers.append(httpMethod);
                headers.append(EXTRA_MESSAGE_NEWLINE);
                headers.append(response.getCode());
                headers.append(EXTRA_MESSAGE_NEWLINE);
                headers.append(EXTRA_MESSAGE_NEWLINE);
                for (Header header : response.getHeaders()) {
                    headers.append(header.getName());
                    headers.append(": ");
                    headers.append(header.getValue());
                    headers.append(EXTRA_MESSAGE_NEWLINE);
                }
                return headers.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getStatusCodeNullSafe(HttpResponse response) {
        int result = -1;
        if (response != null) {
            return response.getCode();
        }
        return result;
    }

    public static FileSizeCheckResult httpHeadRequestWithFileSizeCheck(CloseableHttpClient client, String url, Function<String, String> i18nFn, String username, String password) {
        CloseableHttpResponse headResponse = null;
        try {
            String authHeaderValue;
            HttpHead headRequest = new HttpHead(url);
            if (username != null && (authHeaderValue = HttpDownloaderHelper.getBase64HeaderNullSafe(new Base64Helper(new Base64Inner()), username, password)) != null) {
                headRequest.setHeader("Authorization", authHeaderValue);
            }
            headResponse = client.execute(headRequest);
        }
        catch (Exception e) {
            AdvancedIOException rethrow = new AdvancedIOException(i18nFn.apply("advancedcodeblocks.httpclient.error.http.head.failed"), e);
            String extra = HttpDownloaderHelper.getExtraInfoFromResponseHeadersAndStatusLine(headResponse, "HEAD");
            if (extra == null) {
                extra = e.getMessage();
            }
            rethrow.setExtraMessage(extra);
            throw rethrow;
        }
        int statusCodeNullSafe = HttpDownloaderHelper.getStatusCodeNullSafe(headResponse);
        String extraMessage = HttpDownloaderHelper.getExtraInfoFromResponseHeadersAndStatusLine(headResponse, "HEAD");
        if (statusCodeNullSafe == 401) {
            AdvancedHttpException doThrow = new AdvancedHttpException(i18nFn.apply("advancedcodeblocks.httpclient.error.401.unauthorized"));
            doThrow.setExtraMessage(extraMessage);
            throw doThrow;
        }
        if (statusCodeNullSafe == 404) {
            AdvancedHttpException doThrow = new AdvancedHttpException(i18nFn.apply("advancedcodeblocks.httpclient.error.404.notfound"));
            doThrow.setExtraMessage(extraMessage);
            throw doThrow;
        }
        if (statusCodeNullSafe != 200) {
            AdvancedHttpException doThrow = new AdvancedHttpException(i18nFn.apply("advancedcodeblocks.httpclient.error.4xx.other") + " " + statusCodeNullSafe);
            doThrow.setExtraMessage(extraMessage);
            throw doThrow;
        }
        String contentLengthHeaderOrNull = HttpDownloaderHelper.getHeaderOrNull(headResponse, "Content-Length");
        String encodingChunked = HttpDownloaderHelper.getHeaderOrNull(headResponse, "Transfer-Encoding");
        if (encodingChunked != null && encodingChunked.equalsIgnoreCase("chunked")) {
            return FileSizeCheckResult.SKIPPED_TRANSFER_ENCODING_CHUNKED;
        }
        if (contentLengthHeaderOrNull != null && contentLengthHeaderOrNull.matches("^[0-9]+$")) {
            BigInteger fileSizeInBytes = new BigInteger(contentLengthHeaderOrNull);
            if (fileSizeInBytes.compareTo(AppConstants.MAX_FILESIZE_IN_BYTES) == 1) {
                AdvancedIOException rethrow = new AdvancedIOException(i18nFn.apply("advancedcodeblocks.httpclient.error.file.too.large"));
                rethrow.setExtraMessage(extraMessage);
                throw rethrow;
            }
        } else {
            AdvancedIOException rethrow = new AdvancedIOException(i18nFn.apply("advancedcodeblocks.httpclient.error.contentlength.header.missing"));
            rethrow.setExtraMessage(extraMessage);
            throw rethrow;
        }
        return FileSizeCheckResult.PASSED;
    }

    public static String getExtraMessageMergedWithExceptionMessage(HttpResponse rep, Exception e, String httpMethod) {
        String extraOrNull = HttpDownloaderHelper.getExtraInfoFromResponseHeadersAndStatusLine(rep, httpMethod);
        if (extraOrNull == null) {
            return e.getMessage();
        }
        return e.getMessage() + "\n\n" + extraOrNull;
    }

    public static String httpGetRequest(CloseableHttpClient client, String url, Function<String, String> i18nFn, String username, String password, FileSizeCheckResult fileSizeCheckResult) {
        CloseableHttpResponse getResponse = null;
        try {
            String authHeaderValue;
            HttpGet getRequest = new HttpGet(url);
            if (username != null && (authHeaderValue = HttpDownloaderHelper.getBase64HeaderNullSafe(new Base64Helper(new Base64Inner()), username, password)) != null) {
                getRequest.setHeader("Authorization", authHeaderValue);
            }
            getResponse = client.execute(getRequest);
        }
        catch (Exception e) {
            AdvancedIOException rethrow = new AdvancedIOException(i18nFn.apply("advancedcodeblocks.httpclient.error.http.get.failed"), e);
            rethrow.setExtraMessage(HttpDownloaderHelper.getExtraMessageMergedWithExceptionMessage(getResponse, e, "GET"));
            throw rethrow;
        }
        int statusCodeNullSafe = HttpDownloaderHelper.getStatusCodeNullSafe(getResponse);
        String extraMessage = HttpDownloaderHelper.getExtraInfoFromResponseHeadersAndStatusLine(getResponse, "GET");
        if (statusCodeNullSafe == 401) {
            AdvancedHttpException doThrow = new AdvancedHttpException(i18nFn.apply("advancedcodeblocks.httpclient.error.401.unauthorized"));
            doThrow.setExtraMessage(extraMessage);
            throw doThrow;
        }
        if (statusCodeNullSafe == 404) {
            AdvancedHttpException doThrow = new AdvancedHttpException(i18nFn.apply("advancedcodeblocks.httpclient.error.404.notfound"));
            doThrow.setExtraMessage(extraMessage);
            throw doThrow;
        }
        if (statusCodeNullSafe != 200) {
            AdvancedHttpException doThrow = new AdvancedHttpException(i18nFn.apply("advancedcodeblocks.httpclient.error.4xx.other") + " " + statusCodeNullSafe);
            doThrow.setExtraMessage(extraMessage);
            throw doThrow;
        }
        InputStream responseBodyStream = null;
        try {
            responseBodyStream = getResponse.getEntity().getContent();
        }
        catch (Exception e) {
            AdvancedIOException rethrow = new AdvancedIOException(i18nFn.apply("advancedcodeblocks.httpclient.error.http.get.failed.parse.response.body"), e);
            rethrow.setExtraMessage(HttpDownloaderHelper.getExtraMessageMergedWithExceptionMessage(getResponse, e, "GET"));
            throw rethrow;
        }
        return ChunkedTransferSafeInputStreamReader.streamToStringCappedAtMaxFileSize(new StringWriter(), i18nFn, responseBodyStream, AppConstants.MAX_FILESIZE_IN_BYTES.intValue() / 1000);
    }

    public static CloseableHttpClient createClientWithBasicAuth(String username, String password) {
        int timeout = 3;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds(timeout * 1000)).setConnectionRequestTimeout(Timeout.ofMilliseconds(timeout * 1000)).setContentCompressionEnabled(false).build();
        CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(config).setUserAgent("Advanced Codeblocks for Confluence").build();
        return client;
    }

    public static String getHeaderOrNull(HttpResponse response, String headerKey) {
        if (response == null) {
            return null;
        }
        Header contentLengthHeader = response.getFirstHeader(headerKey);
        if (contentLengthHeader == null) {
            return null;
        }
        return contentLengthHeader.getValue();
    }
}

