/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.parser;

import com.atlassian.confluence.util.HtmlUtil;
import java.nio.charset.Charset;

public class DownloadUrlGenerator {
    protected static String contextPathSafe(String contextPathXorConfluenceBaseUrl) {
        if (contextPathXorConfluenceBaseUrl == null) {
            return "";
        }
        if (contextPathXorConfluenceBaseUrl.endsWith("/")) {
            return contextPathXorConfluenceBaseUrl.substring(0, contextPathXorConfluenceBaseUrl.length() - 1);
        }
        return contextPathXorConfluenceBaseUrl;
    }

    public static String generateDownloadListUrl(String contextPathXorConfluenceBaseUrl, String macroId, Long pageId, boolean encodeAmpersand) {
        String ampersand = encodeAmpersand ? "&amp;" : "&";
        return DownloadUrlGenerator.contextPathSafe(contextPathXorConfluenceBaseUrl) + "/rest/advancedcodeblocks/1/download_list/xml?contentId=" + pageId + ampersand + "macroId=" + macroId;
    }

    public static String generateDownloadCodeBlockUrl(String contextPathXorConfluenceBaseUrl, String macroId, Long pageId, String key, boolean asciiOnly, boolean encodeAmpersand) {
        String ampersand = encodeAmpersand ? "&amp;" : "&";
        Object asciiOnlySuffix = asciiOnly ? ampersand + "asciiOnly=true" : "";
        String keyUrlEncoded = DownloadUrlGenerator.urlEncodeBase64Key(key);
        return DownloadUrlGenerator.contextPathSafe(contextPathXorConfluenceBaseUrl) + "/rest/advancedcodeblocks/1/download_code/plain_text?key=" + keyUrlEncoded + ampersand + "contentId=" + pageId + ampersand + "macroId=" + macroId + (String)asciiOnlySuffix;
    }

    public static String urlEncodeBase64Key(String key) {
        if (key == null) {
            return null;
        }
        Charset charset = Charset.forName("utf-8");
        return HtmlUtil.urlEncode((String)key, (Charset)charset);
    }
}

