/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.plugins.whitelist.OutboundWhitelist;
import com.atlassian.sal.api.message.I18nResolver;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeBlockCache;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeblockCacheKey;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedMalformedURLException;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedOutboundAllowlistUrlNotAllowedException;
import io.codeclou.advanced.codeblock.macro.remote.HttpDownloader;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedCodeblockCacheService {
    private static final String MACRO_CACHE_KEY = "confluenceadvancedcodeblockplugin_v7_map_entry";
    private static final Logger log = LoggerFactory.getLogger(AdvancedCodeblockCacheService.class);
    protected final Function<String, String> i18nFn = this::i18n_getText;
    private CacheManager cacheManager;
    private I18nResolver i18n;
    private OutboundWhitelist outboundWhitelist;
    protected Cache<String, Map.Entry<Date, String>> cache;
    protected CacheLoader<String, Map.Entry<Date, String>> emptyLoader;
    protected HttpDownloader httpDownloader;

    public AdvancedCodeblockCacheService(CacheManager cacheManager, I18nResolver i18n, OutboundWhitelist outboundWhitelist) {
        this.cacheManager = cacheManager;
        this.i18n = i18n;
        this.outboundWhitelist = outboundWhitelist;
        this.httpDownloader = new HttpDownloader();
    }

    protected void init() {
        this.emptyLoader = new CacheLoader<String, Map.Entry<Date, String>>(this){

            public Map.Entry<Date, String> load(String key) {
                return new AbstractMap.SimpleEntry<Object, Object>(null, null);
            }
        };
        this.cache = this.cacheManager.getCache(MACRO_CACHE_KEY, this.emptyLoader, new CacheSettingsBuilder().maxEntries(100).replicateAsynchronously().local().expireAfterWrite(1L, TimeUnit.DAYS).build());
    }

    public AdvancedCodeBlockCache getFromCacheOrDownload(AdvancedCodeblockCacheKey cacheKey, String remoteFileUrl, String remoteFileHttpUser, String remoteFileHttpPassword) throws AdvancedOutboundAllowlistUrlNotAllowedException {
        this.enforceOutBoundWhitelist(remoteFileUrl);
        Map.Entry cacheObjectPrimitive = null;
        try {
            cacheObjectPrimitive = (Map.Entry)this.cache.get((Object)cacheKey.getCacheKey());
        }
        catch (Exception e) {
            log.error(">>> cache get failed due to exception - ", (Throwable)e);
        }
        if (cacheObjectPrimitive == null || cacheObjectPrimitive.getKey() == null && cacheObjectPrimitive.getValue() == null) {
            AdvancedCodeBlockCache cacheObj = new AdvancedCodeBlockCache();
            String remoteFileContent = this.httpDownloader.downloadFile(remoteFileUrl, remoteFileHttpUser, remoteFileHttpPassword, this.i18nFn);
            cacheObj.setRemoteFileContent(remoteFileContent);
            cacheObj.setCreated(this.newDate());
            log.debug(">>> cache miss for " + cacheKey.getCacheKey() + " . Creating new cache entry with date " + cacheObj.getCreated().toString());
            this.cache.put((Object)cacheKey.getCacheKey(), new AbstractMap.SimpleEntry<Date, String>(cacheObj.getCreated(), cacheObj.getRemoteFileContent()));
            return cacheObj;
        }
        log.debug(">>> cache hit for " + cacheKey.getCacheKey());
        AdvancedCodeBlockCache cacheObj = new AdvancedCodeBlockCache();
        cacheObj.setCreated((Date)cacheObjectPrimitive.getKey());
        cacheObj.setRemoteFileContent((String)cacheObjectPrimitive.getValue());
        return cacheObj;
    }

    public void removeFromCache(AdvancedCodeblockCacheKey cacheKey) throws Exception {
        this.cache.remove((Object)cacheKey.getCacheKey());
    }

    protected void enforceOutBoundWhitelist(String url) throws AdvancedOutboundAllowlistUrlNotAllowedException {
        try {
            URL uri = new URL(url);
            if (!this.outboundWhitelist.isAllowed(uri.toURI())) {
                throw new AdvancedOutboundAllowlistUrlNotAllowedException(url);
            }
        }
        catch (AdvancedOutboundAllowlistUrlNotAllowedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AdvancedMalformedURLException(e.getMessage());
        }
    }

    protected Date newDate() {
        return new Date();
    }

    public String i18n_getText(String key) {
        String result = key;
        result = this.i18n.getText(key);
        return result;
    }
}

