/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.locale;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils2.BeanUtils;
import org.apache.commons.beanutils2.locale.LocaleBeanUtilsBean;
import org.apache.commons.beanutils2.locale.LocaleConverter;
import org.apache.commons.beanutils2.locale.converters.BigDecimalLocaleConverter;
import org.apache.commons.beanutils2.locale.converters.BigIntegerLocaleConverter;
import org.apache.commons.beanutils2.locale.converters.ByteLocaleConverter;
import org.apache.commons.beanutils2.locale.converters.DoubleLocaleConverter;
import org.apache.commons.beanutils2.locale.converters.FloatLocaleConverter;
import org.apache.commons.beanutils2.locale.converters.IntegerLocaleConverter;
import org.apache.commons.beanutils2.locale.converters.LongLocaleConverter;
import org.apache.commons.beanutils2.locale.converters.ShortLocaleConverter;
import org.apache.commons.beanutils2.locale.converters.StringLocaleConverter;
import org.apache.commons.beanutils2.sql.converters.locale.SqlDateLocaleConverter;
import org.apache.commons.beanutils2.sql.converters.locale.SqlTimeLocaleConverter;
import org.apache.commons.beanutils2.sql.converters.locale.SqlTimestampLocaleConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocaleConvertUtilsBean {
    private static final Log LOG = LogFactory.getLog(LocaleConvertUtilsBean.class);
    private Locale defaultLocale = Locale.getDefault();
    private boolean applyLocalized;
    private final Map<Locale, Map<Class<?>, LocaleConverter<?>>> mapConverters = BeanUtils.createCache();

    public static LocaleConvertUtilsBean getInstance() {
        return LocaleBeanUtilsBean.getLocaleBeanUtilsInstance().getLocaleConvertUtils();
    }

    public LocaleConvertUtilsBean() {
        this.deregister();
    }

    public String convert(Object value) {
        return this.convert(value, this.defaultLocale, null);
    }

    public String convert(Object value, Locale locale, String pattern) {
        LocaleConverter<String> converter = this.lookup(String.class, locale);
        return converter.convert(String.class, value, pattern);
    }

    public String convert(Object value, String pattern) {
        return this.convert(value, this.defaultLocale, pattern);
    }

    public Object convert(String value, Class<?> clazz) {
        return this.convert(value, clazz, this.defaultLocale, null);
    }

    public Object convert(String value, Class<?> clazz, Locale locale, String pattern) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Convert string " + value + " to class " + clazz.getName() + " using " + locale + " locale and " + pattern + " pattern");
        }
        Class<Object> targetClass = clazz;
        LocaleConverter<Object> converter = this.lookup(clazz, locale);
        if (converter == null) {
            converter = this.lookup(String.class, locale);
            targetClass = String.class;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("  Using converter " + converter);
        }
        return converter.convert(targetClass, value, pattern);
    }

    public Object convert(String value, Class<?> clazz, String pattern) {
        return this.convert(value, clazz, this.defaultLocale, pattern);
    }

    public Object convert(String[] values, Class<?> clazz) {
        return this.convert(values, clazz, this.getDefaultLocale(), null);
    }

    public <T> T[] convert(String[] values, Class<T> clazz, Locale locale, String pattern) {
        Class<Object> type = clazz;
        if (clazz.isArray()) {
            type = clazz.getComponentType();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Convert String[" + values.length + "] to class " + type.getName() + "[] using " + locale + " locale and " + pattern + " pattern");
        }
        Object[] array = (Object[])Array.newInstance(type, values.length);
        for (int i = 0; i < values.length; ++i) {
            Array.set(array, i, this.convert(values[i], type, locale, pattern));
        }
        return array;
    }

    public <T> T[] convert(String[] values, Class<T> clazz, String pattern) {
        return this.convert(values, clazz, this.getDefaultLocale(), pattern);
    }

    protected Map<Class<?>, LocaleConverter<?>> create(Locale locale) {
        Map<Class<?>, LocaleConverter<?>> converter = BeanUtils.createCache();
        converter.put(BigDecimal.class, ((BigDecimalLocaleConverter.Builder)((BigDecimalLocaleConverter.Builder)BigDecimalLocaleConverter.builder().setLocale(locale)).setLocalizedPattern(this.applyLocalized)).get());
        converter.put(BigInteger.class, ((BigIntegerLocaleConverter.Builder)((BigIntegerLocaleConverter.Builder)BigIntegerLocaleConverter.builder().setLocale(locale)).setLocalizedPattern(this.applyLocalized)).get());
        converter.put(Byte.class, ((ByteLocaleConverter.Builder)((ByteLocaleConverter.Builder)ByteLocaleConverter.builder().setLocale(locale)).setLocalizedPattern(this.applyLocalized)).get());
        converter.put(Byte.TYPE, ((ByteLocaleConverter.Builder)((ByteLocaleConverter.Builder)ByteLocaleConverter.builder().setLocale(locale)).setLocalizedPattern(this.applyLocalized)).get());
        converter.put(Double.class, ((DoubleLocaleConverter.Builder)((DoubleLocaleConverter.Builder)DoubleLocaleConverter.builder().setLocale(locale)).setLocalizedPattern(this.applyLocalized)).get());
        converter.put(Double.TYPE, ((DoubleLocaleConverter.Builder)((DoubleLocaleConverter.Builder)DoubleLocaleConverter.builder().setLocale(locale)).setLocalizedPattern(this.applyLocalized)).get());
        converter.put(Float.class, ((FloatLocaleConverter.Builder)((FloatLocaleConverter.Builder)FloatLocaleConverter.builder().setLocale(locale)).setLocalizedPattern(this.applyLocalized)).get());
        converter.put(Float.TYPE, ((FloatLocaleConverter.Builder)((FloatLocaleConverter.Builder)FloatLocaleConverter.builder().setLocale(locale)).setLocalizedPattern(this.applyLocalized)).get());
        converter.put(Integer.class, ((IntegerLocaleConverter.Builder)((IntegerLocaleConverter.Builder)IntegerLocaleConverter.builder().setLocale(locale)).setLocalizedPattern(this.applyLocalized)).get());
        converter.put(Integer.TYPE, ((IntegerLocaleConverter.Builder)((IntegerLocaleConverter.Builder)IntegerLocaleConverter.builder().setLocale(locale)).setLocalizedPattern(this.applyLocalized)).get());
        converter.put(Long.class, ((LongLocaleConverter.Builder)((LongLocaleConverter.Builder)LongLocaleConverter.builder().setLocale(locale)).setLocalizedPattern(this.applyLocalized)).get());
        converter.put(Long.TYPE, ((LongLocaleConverter.Builder)((LongLocaleConverter.Builder)LongLocaleConverter.builder().setLocale(locale)).setLocalizedPattern(this.applyLocalized)).get());
        converter.put(Short.class, ((ShortLocaleConverter.Builder)((ShortLocaleConverter.Builder)ShortLocaleConverter.builder().setLocale(locale)).setLocalizedPattern(this.applyLocalized)).get());
        converter.put(Short.TYPE, ((ShortLocaleConverter.Builder)((ShortLocaleConverter.Builder)ShortLocaleConverter.builder().setLocale(locale)).setLocalizedPattern(this.applyLocalized)).get());
        converter.put(String.class, ((StringLocaleConverter.Builder)((StringLocaleConverter.Builder)StringLocaleConverter.builder().setLocale(locale)).setLocalizedPattern(this.applyLocalized)).get());
        converter.put(Date.class, ((SqlDateLocaleConverter.Builder)((SqlDateLocaleConverter.Builder)SqlDateLocaleConverter.builder().setLocale(locale)).setPattern("yyyy-MM-dd")).get());
        converter.put(Time.class, ((SqlTimeLocaleConverter.Builder)((SqlTimeLocaleConverter.Builder)SqlTimeLocaleConverter.builder().setLocale(locale)).setPattern("HH:mm:ss")).get());
        converter.put(Timestamp.class, ((SqlTimestampLocaleConverter.Builder)((SqlTimestampLocaleConverter.Builder)SqlTimestampLocaleConverter.builder().setLocale(locale)).setPattern("yyyy-MM-dd HH:mm:ss.S")).get());
        return converter;
    }

    public void deregister() {
        Map<Class<?>, LocaleConverter<?>> defaultConverter = this.lookup(this.defaultLocale);
        this.mapConverters.clear();
        this.mapConverters.put(this.defaultLocale, defaultConverter);
    }

    public void deregister(Class<?> clazz, Locale locale) {
        this.lookup(locale).remove(clazz);
    }

    public void deregister(Locale locale) {
        this.mapConverters.remove(locale);
    }

    public boolean getApplyLocalized() {
        return this.applyLocalized;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public <T> LocaleConverter<T> lookup(Class<T> clazz, Locale locale) {
        LocaleConverter<?> converter = this.lookup(locale).get(clazz);
        if (LOG.isTraceEnabled()) {
            LOG.trace("LocaleConverter:" + converter);
        }
        return converter;
    }

    protected Map<Class<?>, LocaleConverter<?>> lookup(Locale locale) {
        return this.mapConverters.computeIfAbsent(locale == null ? this.defaultLocale : locale, this::create);
    }

    public <T> void register(LocaleConverter<T> converter, Class<T> clazz, Locale locale) {
        this.lookup(locale).put(clazz, converter);
    }

    public void setApplyLocalized(boolean newApplyLocalized) {
        this.applyLocalized = newApplyLocalized;
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale == null ? Locale.getDefault() : locale;
    }
}

