/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.services;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.confluence.user.UserPreferencesAccessor;
import io.codeclou.advanced.codeblock.macro.rest.model.CustomResponseType;
import io.codeclou.advanced.codeblock.macro.rest.model.RestErrorModel;
import io.codeclou.advanced.codeblock.macro.rest.transformer.RestModelTransformer;
import io.codeclou.advanced.codeblock.macro.services.ContentAndPermissionService;
import io.codeclou.advanced.codeblock.macro.services.model.ErrorResponseOrPageOrCommentOrBlog;
import io.codeclou.advanced.codeblock.macro.services.model.HasPermissionAndContent;
import jakarta.ws.rs.core.Response;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class LoggedInConfluenceUserService {
    private UserPreferencesAccessor userAccessor;
    private ContentAndPermissionService contentOrDraftService;

    public LoggedInConfluenceUserService(UserPreferencesAccessor userAccessor, ContentAndPermissionService contentOrDraftService) {
        this.userAccessor = userAccessor;
        this.contentOrDraftService = contentOrDraftService;
    }

    public ErrorResponseOrPageOrCommentOrBlog enforceAuthenticationAndAuthorization(Long contentId, CustomResponseType type) {
        ErrorResponseOrPageOrCommentOrBlog returnObj = new ErrorResponseOrPageOrCommentOrBlog();
        ConfluenceUser confluenceUser = this.getLoggedInUser();
        RestModelTransformer transformer = new RestModelTransformer();
        if (confluenceUser != null) {
            HasPermissionAndContent permissionAndContent = this.contentOrDraftService.findContentByIdAndCheckPermission(contentId, confluenceUser);
            returnObj.setContent(permissionAndContent.getContent());
            returnObj.setHasError(permissionAndContent.getUserHasPermissionOnContent() == false);
            if (!permissionAndContent.getUserHasPermissionOnContent().booleanValue()) {
                RestErrorModel error = new RestErrorModel("403_FORBIDDEN", "You do not have read permission for this page, blog, comment or draft.", "contentId = " + contentId.toString());
                error.setErrorCode("AUTH");
                returnObj.setResponse(Response.ok((Object)transformer.transform_RestErrorModel_toExternalFormByType(error, type)).status(Response.Status.FORBIDDEN).build());
                returnObj.setContent(null);
                returnObj.setHasError(true);
            }
            return returnObj;
        }
        RestErrorModel error = new RestErrorModel("401_UNAUTHORIZED", "You are not logged in.", null);
        error.setErrorCode("AUTH");
        returnObj.setResponse(Response.ok((Object)transformer.transform_RestErrorModel_toExternalFormByType(error, type)).status(Response.Status.UNAUTHORIZED).build());
        returnObj.setContent(null);
        returnObj.setHasError(true);
        return returnObj;
    }

    public ConfluenceUser getLoggedInUser() {
        return this.getLoggedInConfluenceUser();
    }

    protected ConfluenceUser getLoggedInConfluenceUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    public String getRemoteUserTimeZone() {
        UserPreferences preferences;
        ConfluenceUser user = this.getLoggedInConfluenceUser();
        if (user != null && (preferences = this.userAccessor.getUserPreferences(user)) != null && preferences.getTimeZone() != null) {
            return preferences.getTimeZone().getID();
        }
        return "";
    }

    public String getRemoteUserLocale() {
        UserPreferences preferences;
        ConfluenceUser user = this.getLoggedInConfluenceUser();
        if (user != null && (preferences = this.userAccessor.getUserPreferences(user)) != null && preferences.getLocale() != null) {
            return preferences.getLocale().toLanguageTag();
        }
        return "";
    }

    public String getUtcIsoDateString(Date d) {
        if (d != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'+0000'", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format.format(d);
        }
        return "1970-01-01T04:20:00+0000";
    }
}

