/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeBlockMacroPreviewCache;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeblockMacroPreviewCacheKey;
import io.codeclou.advanced.codeblock.macro.macro.fetcher.MacroBodyAndParams;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedCodeblockMacroPreviewCacheService {
    private static final String MACRO_PREVIEW_CACHE_KEY = "confluenceadvancedcodeblockplugin_preview";
    private static final Logger log = LoggerFactory.getLogger(AdvancedCodeblockMacroPreviewCacheService.class);
    private CacheManager cacheManager;
    protected Cache<String, AdvancedCodeBlockMacroPreviewCache> cachePreview;
    protected CacheLoader<String, AdvancedCodeBlockMacroPreviewCache> emptyPreviewLoader;

    public AdvancedCodeblockMacroPreviewCacheService(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected void init() {
        this.emptyPreviewLoader = new CacheLoader<String, AdvancedCodeBlockMacroPreviewCache>(this){

            public AdvancedCodeBlockMacroPreviewCache load(String key) {
                return new AdvancedCodeBlockMacroPreviewCache();
            }
        };
        this.cachePreview = this.cacheManager.getCache(MACRO_PREVIEW_CACHE_KEY, this.emptyPreviewLoader, new CacheSettingsBuilder().maxEntries(10000).replicateAsynchronously().local().expireAfterWrite(1L, TimeUnit.MINUTES).build());
    }

    public void putToCache(AdvancedCodeblockMacroPreviewCacheKey key, AdvancedCodeBlockMacroPreviewCache cacheItem) {
        this.cachePreview.put((Object)key.getCacheKey(), (Object)cacheItem);
    }

    public MacroBodyAndParams getFromCache(AdvancedCodeblockMacroPreviewCacheKey key) {
        AdvancedCodeBlockMacroPreviewCache cacheEntry = (AdvancedCodeBlockMacroPreviewCache)this.cachePreview.get((Object)key.getCacheKey());
        if (cacheEntry != null) {
            return new MacroBodyAndParams(cacheEntry.getTypedParameters() != null ? cacheEntry.getTypedParameters() : new HashMap<String, Object>(), cacheEntry.getBody(), cacheEntry.getMacroType());
        }
        return null;
    }
}

