/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.paramvalidator;

import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedInvalidUrlParameterException;
import java.util.regex.Pattern;

public class UrlParameterValidator {
    private static Pattern keyPattern = Pattern.compile("^[%=+/A-Za-z0-9]+$");
    private static Pattern macroIdPattern = Pattern.compile("^[-A-Za-z0-9]+$");

    public static void enforceValidMacroId(String macroId) throws AdvancedInvalidUrlParameterException {
        if (macroId == null) {
            throw new AdvancedInvalidUrlParameterException("Invalid macroId. Is null.");
        }
        if (!macroIdPattern.matcher(macroId).matches()) {
            throw new AdvancedInvalidUrlParameterException("Invalid macroId. Allowed chars [-A-Za-z0-9]+.");
        }
    }

    public static void enforceValidBase64Key(String key) throws AdvancedInvalidUrlParameterException {
        if (key == null) {
            throw new AdvancedInvalidUrlParameterException("Invalid key. Is null.");
        }
        if (!keyPattern.matcher(key).matches()) {
            throw new AdvancedInvalidUrlParameterException("Invalid key. Allowed chars [%=+/A-Za-z0-9]+.");
        }
    }
}

