/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.rest.model;

import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedBaseException;
import io.codeclou.advanced.codeblock.macro.services.model.LicenseInformation;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class RestErrorModel {
    @XmlElement
    private String error;
    @XmlElement
    private String errorCode;
    @XmlElement
    private String message;
    @XmlElement
    private String extraMessage;

    RestErrorModel() {
    }

    public RestErrorModel(String error, String message, String extraMessage) {
        this.error = error;
        this.message = message;
        this.extraMessage = extraMessage;
        this.errorCode = null;
    }

    public RestErrorModel(LicenseInformation licenseInformation) {
        this.error = "500_ERROR_LICENSE_EXCEPTION";
        this.message = licenseInformation.getLicenseErrorMessage();
        this.extraMessage = null;
        this.errorCode = licenseInformation.getLicenseErrorType();
    }

    public RestErrorModel(AdvancedBaseException e) {
        this.error = e.getRestExceptionKey();
        this.message = e.getMessage();
        this.extraMessage = e.getExtraMessage();
        this.errorCode = e.getErrorCode();
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getExtraMessage() {
        return this.extraMessage;
    }

    public void setExtraMessage(String extraMessage) {
        this.extraMessage = extraMessage;
    }
}

