/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.services;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.HostLicenseInformation;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import io.codeclou.advanced.codeblock.macro.services.model.LicenseInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginLicenseService {
    private Logger logger = LoggerFactory.getLogger(PluginLicenseService.class);
    private static final String APP_NAME = "Advanced Codeblocks";
    private final PluginLicenseManager pluginLicenseManager;
    private final HostLicenseInformation hostLicenseInformation;

    @Autowired
    public PluginLicenseService(@ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport HostLicenseInformation upmHostLicenseInformation) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.hostLicenseInformation = upmHostLicenseInformation;
    }

    public LicenseInformation detectLicense() {
        LicenseInformation licenseInformation = new LicenseInformation();
        if (this.hostLicenseInformation.getEdition().isDefined()) {
            licenseInformation.setDetailHostLicenseEdition(((Integer)this.hostLicenseInformation.getEdition().get()).toString());
        } else {
            licenseInformation.setDetailHostLicenseEdition("unlimited");
        }
        licenseInformation.setDetailAppLicenseIsDataCenter(this.hostLicenseInformation.isDataCenter());
        licenseInformation.setDetailHostLicenseIsEvaluation(this.hostLicenseInformation.isEvaluation());
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (license.getEdition().isDefined()) {
                licenseInformation.setDetailAppLicenseEdition(((Integer)license.getEdition().get()).toString());
            } else {
                licenseInformation.setDetailAppLicenseEdition("unlimited");
            }
            licenseInformation.setDetailAppLicenseIsDataCenter(license.isDataCenter());
            licenseInformation.setDetailAppLicenseIsEvaluation(license.isEvaluation());
            if (license.getError().isDefined()) {
                if (LicenseError.EXPIRED.equals(license.getError().get())) {
                    licenseInformation.setLicenseErrors(true);
                    licenseInformation.setLicenseErrorType("EXPIRED");
                    licenseInformation.setLicenseErrorMessage("Invalid license: Your evaluation license of Advanced Codeblocks expired. Please use the 'Buy' button to purchase a new license.");
                } else if (LicenseError.TYPE_MISMATCH.equals(license.getError().get())) {
                    licenseInformation.setLicenseErrors(true);
                    licenseInformation.setLicenseErrorType("TYPE_MISMATCH");
                    licenseInformation.setLicenseErrorMessage("Invalid license: Your evaluation license of Advanced Codeblocks expired. Please use the 'Buy' button to purchase a new license.");
                } else if (LicenseError.USER_MISMATCH.equals(license.getError().get())) {
                    licenseInformation.setLicenseErrors(true);
                    licenseInformation.setLicenseErrorType("USER_MISMATCH");
                    licenseInformation.setLicenseErrorMessage("Invalid license: Your Advanced Codeblocks is only licensed for " + licenseInformation.getDetailAppLicenseEdition() + ". Your Confluence installation requires a license for " + licenseInformation.getDetailHostLicenseEdition() + " users. Please get a Advanced Codeblocks license for " + licenseInformation.getDetailHostLicenseEdition() + " users and try again.");
                } else if (LicenseError.EDITION_MISMATCH.equals(license.getError().get())) {
                    licenseInformation.setLicenseErrors(true);
                    licenseInformation.setLicenseErrorType("EDITION_MISMATCH");
                    licenseInformation.setLicenseErrorMessage("Invalid license: Your Advanced Codeblocks is only licensed for " + licenseInformation.getDetailAppLicenseEdition() + ". Your Confluence installation requires a license for " + licenseInformation.getDetailHostLicenseEdition() + " remote agents. Please get a Advanced Codeblocks license for " + licenseInformation.getDetailHostLicenseEdition() + " users and try again.");
                } else {
                    licenseInformation.setLicenseErrorType(((LicenseError)license.getError().get()).toString());
                    licenseInformation.setLicenseErrorMessage("Unknown license error. The License is somehow not valid.");
                    licenseInformation.setLicenseErrors(true);
                }
            } else {
                licenseInformation.setLicenseErrors(false);
            }
        } else {
            licenseInformation.setLicenseErrorType("UNLICENSED");
            licenseInformation.setLicenseErrorMessage("There is no license present for Advanced Codeblocks. Please get a Advanced Codeblocks license for " + licenseInformation.getDetailHostLicenseEdition() + " users and try again.");
            licenseInformation.setLicenseErrors(true);
        }
        return licenseInformation;
    }
}

