/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.services;

import com.atlassian.confluence.content.service.BlogPostService;
import com.atlassian.confluence.content.service.DraftService;
import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.content.service.blogpost.BlogPostLocator;
import com.atlassian.confluence.core.service.NotValidException;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.codeclou.advanced.codeblock.macro.rest.model.PageBlogOrCommentDTO;
import io.codeclou.advanced.codeblock.macro.services.model.HasPermissionAndContent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContentAndPermissionService {
    private final DraftService draftService;
    private final PermissionManager permissionManager;
    private final CommentManager commentManager;
    private final BlogPostService blogPostService;
    private final PageService pageService;

    @Autowired
    public ContentAndPermissionService(@ComponentImport DraftService draftService, @ComponentImport BlogPostService blogPostService, @ComponentImport CommentManager commentManager, @ComponentImport PermissionManager permissionManager, @ComponentImport PageService pageService) {
        this.draftService = draftService;
        this.commentManager = commentManager;
        this.blogPostService = blogPostService;
        this.permissionManager = permissionManager;
        this.pageService = pageService;
    }

    public HasPermissionAndContent findContentByIdAndCheckPermission(Long contentId, ConfluenceUser confluenceUser) {
        Page page = this.getPageById(contentId);
        if (page != null) {
            boolean hasPermission = this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, (Object)page);
            PageBlogOrCommentDTO dto = new PageBlogOrCommentDTO(page);
            return new HasPermissionAndContent(hasPermission, dto);
        }
        Comment comment = this.getCommentById(contentId);
        if (comment != null) {
            boolean hasPermission = this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, (Object)comment);
            PageBlogOrCommentDTO dto = new PageBlogOrCommentDTO(comment);
            return new HasPermissionAndContent(hasPermission, dto);
        }
        BlogPost blogPost = this.getBlogPost(contentId);
        if (blogPost != null) {
            boolean hasPermission = this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, (Object)blogPost);
            PageBlogOrCommentDTO dto = new PageBlogOrCommentDTO(blogPost);
            return new HasPermissionAndContent(hasPermission, dto);
        }
        Draft draft = this.findDraftByIdOrNull(contentId);
        if (draft != null) {
            boolean hasPermission = this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, (Object)draft);
            PageBlogOrCommentDTO dto = new PageBlogOrCommentDTO(draft);
            return new HasPermissionAndContent(hasPermission, dto);
        }
        return new HasPermissionAndContent(false, new PageBlogOrCommentDTO());
    }

    public Comment getCommentById(Long pageId) {
        return this.commentManager.getComment(pageId.longValue());
    }

    public BlogPost getBlogPost(Long pageId) {
        BlogPostLocator bl = this.blogPostService.getIdBlogPostLocator(pageId.longValue());
        if (bl != null) {
            return bl.getBlogPost();
        }
        return null;
    }

    public Draft findDraftByIdOrNull(Long contentId) {
        try {
            return this.draftService.getDraft(contentId.longValue());
        }
        catch (NotValidException notValidException) {
            return null;
        }
    }

    public Page getPageById(Long pageId) {
        try {
            return this.pageService.getIdPageLocator(pageId.longValue()).getPage();
        }
        catch (Exception e) {
            return null;
        }
    }
}

