/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.rest.transformer;

import io.codeclou.advanced.codeblock.macro.helper.AssertUtils;
import io.codeclou.advanced.codeblock.macro.helper.JsonProcessor;
import io.codeclou.advanced.codeblock.macro.rest.model.CacheRefreshOk;
import io.codeclou.advanced.codeblock.macro.rest.model.CustomResponseType;
import io.codeclou.advanced.codeblock.macro.rest.model.DownloadConfigApiModel;
import io.codeclou.advanced.codeblock.macro.rest.model.DownloadConfigSectionApiModel;
import io.codeclou.advanced.codeblock.macro.rest.model.DownloadListApiModel;
import io.codeclou.advanced.codeblock.macro.rest.model.DownloadListCodeBlockApiModel;
import io.codeclou.advanced.codeblock.macro.rest.model.RestErrorModel;
import org.apache.commons.text.StringEscapeUtils;

public class RestModelTransformer {
    public String transform_CacheRefreshOk_toJson(CacheRefreshOk obj) {
        JsonProcessor jsonProcessor = new JsonProcessor();
        return jsonProcessor.toJson(obj);
    }

    public static String transform_DownloadConfigApiModel_toJson(DownloadConfigApiModel obj) {
        JsonProcessor jsonProcessor = new JsonProcessor();
        return jsonProcessor.toJson(obj);
    }

    public static String transform_DownloadConfigSectionApiModel_toJson(DownloadConfigSectionApiModel obj) {
        JsonProcessor jsonProcessor = new JsonProcessor();
        return jsonProcessor.toJson(obj);
    }

    public String transform_DownloadListApiModel_toXML(DownloadListApiModel obj) {
        StringBuilder stb = new StringBuilder();
        stb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stb.append("<advancedCodeblockMacro>\n");
        stb.append("<content>\n");
        stb.append("  <contentId>" + obj.getContent().getContentId() + "</contentId>\n");
        stb.append("  <contentType>" + obj.getContent().getContentType() + "</contentType>\n");
        stb.append("  <contentTitle>" + StringEscapeUtils.escapeXml11(obj.getContent().getContentTitle()) + "</contentTitle>\n");
        stb.append("  <spaceKey>" + obj.getContent().getSpaceKey() + "</spaceKey>\n");
        stb.append("  <macroId>" + obj.getContent().getMacroId() + "</macroId>\n");
        stb.append("</content>\n");
        stb.append("<codeBlocks>\n");
        if (AssertUtils.notNullAndNotEmptyList(obj.getCodeBlocks())) {
            for (DownloadListCodeBlockApiModel codeBlock : obj.getCodeBlocks()) {
                stb.append("  <codeBlock>\n");
                stb.append("    <key>" + codeBlock.getKey() + "</key>\n");
                stb.append("    <name>" + StringEscapeUtils.escapeXml11(codeBlock.getName()) + "</name>\n");
                stb.append("    <download>" + codeBlock.getDownload() + "</download>\n");
                stb.append("  </codeBlock>\n");
            }
        }
        stb.append("</codeBlocks>\n");
        stb.append("</advancedCodeblockMacro>\n");
        return stb.toString();
    }

    public String transform_DownloadListApiModel_toJSON(DownloadListApiModel obj) {
        JsonProcessor jsonProcessor = new JsonProcessor();
        return jsonProcessor.toJson(obj);
    }

    public String transform_RestErrorModel_toExternalFormByType(RestErrorModel obj, CustomResponseType type) {
        if (type == CustomResponseType.XML) {
            return this.transform_RestErrorModel_toXML(obj);
        }
        if (type == CustomResponseType.JSON) {
            return this.transform_RestErrorModel_toJSON(obj);
        }
        return this.transform_RestErrorModel_toPLAIN_TEXT(obj);
    }

    public String transform_RestErrorModel_toXML(RestErrorModel obj) {
        StringBuilder stb = new StringBuilder();
        stb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stb.append("<advancedCodeblockMacro>");
        stb.append("  <error>" + StringEscapeUtils.escapeXml11(obj.getError()) + "</error>");
        stb.append("  <message>" + StringEscapeUtils.escapeXml11(obj.getMessage()) + "</message>");
        stb.append("  <extraMessage>" + (obj.getExtraMessage() != null ? StringEscapeUtils.escapeXml11(obj.getExtraMessage()) : "") + "</extraMessage>");
        stb.append("  <errorCode>" + (obj.getErrorCode() != null ? StringEscapeUtils.escapeXml11(obj.getErrorCode()) : "") + "</errorCode>");
        stb.append("</advancedCodeblockMacro>");
        return stb.toString();
    }

    public String transform_RestErrorModel_toPLAIN_TEXT(RestErrorModel obj) {
        StringBuilder stb = new StringBuilder();
        stb.append(obj.getError());
        stb.append(" ");
        stb.append("(" + obj.getMessage() + ")");
        if (obj.getExtraMessage() != null) {
            stb.append("\n[" + obj.getExtraMessage() + "]");
        }
        if (obj.getErrorCode() != null) {
            stb.append("\n[errorCode:" + obj.getErrorCode() + "]");
        }
        return stb.toString();
    }

    public String transform_RestErrorModel_toJSON(RestErrorModel obj) {
        JsonProcessor jsonProcessor = new JsonProcessor();
        return jsonProcessor.toJson(obj);
    }

    public String transform_DownloadConfigApiModel_toJSON(DownloadConfigApiModel obj) {
        JsonProcessor jsonProcessor = new JsonProcessor();
        return jsonProcessor.toJson(obj);
    }
}

