/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.rest.model;

import io.codeclou.advanced.codeblock.macro.helper.AssertUtils;
import io.codeclou.advanced.codeblock.macro.parser.DownloadUrlGenerator;
import io.codeclou.advanced.codeblock.macro.parser.model.CodeBlockSection;
import io.codeclou.advanced.codeblock.macro.rest.model.CustomResponseType;
import io.codeclou.advanced.codeblock.macro.rest.model.DownloadListCodeBlockApiModel;
import io.codeclou.advanced.codeblock.macro.rest.model.DownloadListContentApiModel;
import io.codeclou.advanced.codeblock.macro.rest.model.PageBlogOrCommentDTO;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class DownloadListApiModel {
    @XmlElement
    private DownloadListContentApiModel content = new DownloadListContentApiModel();
    @XmlElement
    private List<DownloadListCodeBlockApiModel> codeBlocks = new ArrayList<DownloadListCodeBlockApiModel>();

    public DownloadListContentApiModel getContent() {
        return this.content;
    }

    public void setContent(DownloadListContentApiModel content) {
        this.content = content;
    }

    public List<DownloadListCodeBlockApiModel> getCodeBlocks() {
        return this.codeBlocks;
    }

    public void setCodeBlocks(List<DownloadListCodeBlockApiModel> codeBlocks) {
        this.codeBlocks = codeBlocks;
    }

    public static DownloadListApiModel from(List<CodeBlockSection> codeBlockSections, String baseUrl, PageBlogOrCommentDTO contentDTO, String macroId, CustomResponseType type) {
        DownloadListApiModel model = new DownloadListApiModel();
        model.content.setSpaceKey(contentDTO.getSpaceKey());
        model.content.setContentId(contentDTO.getContentId());
        model.content.setContentType(contentDTO.getContentType());
        model.content.setContentTitle(contentDTO.getContentTitle());
        model.content.setMacroId(macroId);
        if (AssertUtils.notNullAndNotEmptyList(codeBlockSections)) {
            for (CodeBlockSection section : codeBlockSections) {
                DownloadListCodeBlockApiModel codeBlock = new DownloadListCodeBlockApiModel();
                codeBlock.setDownload(DownloadUrlGenerator.generateDownloadCodeBlockUrl(baseUrl, macroId, contentDTO.getContentId(), section.sectionTitleBase64, false, CustomResponseType.XML == type));
                codeBlock.setKey(section.sectionTitleBase64);
                codeBlock.setName(section.sectionTitle);
                model.codeBlocks.add(codeBlock);
            }
        }
        DownloadListCodeBlockApiModel codeBlock = new DownloadListCodeBlockApiModel();
        codeBlock.setDownload(DownloadUrlGenerator.generateDownloadCodeBlockUrl(baseUrl, macroId, contentDTO.getContentId(), "cmF3", false, CustomResponseType.XML == type));
        codeBlock.setKey("cmF3");
        codeBlock.setName("raw");
        model.codeBlocks.add(codeBlock);
        return model;
    }
}

