/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.remote;

import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedChunkedReadException;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedIOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;

public class ChunkedTransferSafeInputStreamReader {
    public static String streamToStringCappedAtMaxFileSize(StringWriter stringWriter, Function<String, String> i18nFn, InputStream is, int maxLengthInKiloBytes) throws AdvancedIOException, AdvancedChunkedReadException {
        int maxLengthInBytes = maxLengthInKiloBytes * 1000;
        byte[] buffer = new byte[4096];
        int totalRead = 0;
        int read = 0;
        boolean doThrowChunkedException = false;
        do {
            try {
                stringWriter.write(new String(buffer, 0, read, StandardCharsets.UTF_8));
                read = is.read(buffer, 0, buffer.length);
                if ((totalRead += read) >= maxLengthInBytes) {
                    doThrowChunkedException = true;
                }
            }
            catch (Exception e) {
                AdvancedIOException rethrow = new AdvancedIOException(i18nFn.apply("advancedcodeblocks.httpclient.error.http.chunked.read.failed.unexpectedly"), e);
                if (e.getMessage() != null) {
                    rethrow.setExtraMessage(e.getMessage());
                }
                throw rethrow;
            }
            if (!doThrowChunkedException) continue;
            throw new AdvancedChunkedReadException(i18nFn.apply("advancedcodeblocks.httpclient.error.http.chunked.read.failed.file.too.big"));
        } while (read != -1);
        return stringWriter.toString();
    }
}

