/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.macro.fetcher;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedFetchMacroException;
import io.codeclou.advanced.codeblock.macro.macro.fetcher.GetParamsAndBodyMacroHandler;
import io.codeclou.advanced.codeblock.macro.macro.fetcher.GetParamsAndBodyMacroHandlerService;
import io.codeclou.advanced.codeblock.macro.macro.fetcher.MacroBodyAndParams;
import io.codeclou.advanced.codeblock.macro.rest.model.PageBlogOrCommentDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FetchingMacroDefinitionHandler {
    private final XhtmlContent xhtmlContent;
    private final GetParamsAndBodyMacroHandlerService getParamsAndBodyMacroHandlerService;

    @Autowired
    public FetchingMacroDefinitionHandler(XhtmlContent xhtmlContent, GetParamsAndBodyMacroHandlerService getParamsAndBodyMacroHandlerService) {
        this.xhtmlContent = xhtmlContent;
        this.getParamsAndBodyMacroHandlerService = getParamsAndBodyMacroHandlerService;
    }

    public MacroBodyAndParams getMacroParametersAndBodyById(PageBlogOrCommentDTO content, String macroId) throws AdvancedFetchMacroException {
        return this.getMacroParametersAndBody(content, macroId);
    }

    private MacroBodyAndParams getMacroParametersAndBody(PageBlogOrCommentDTO content, String macroId) throws AdvancedFetchMacroException {
        GetParamsAndBodyMacroHandler getParamsAndBodyMacroHandler = this.getParamsAndBodyMacroHandlerService.getParamsAndBodyMacroHandler(macroId);
        try {
            this.xhtmlContent.handleMacroDefinitions(content.getBodyAsXhtmlStorageFormat(), (ConversionContext)new DefaultConversionContext(new RenderContext()), (MacroDefinitionHandler)getParamsAndBodyMacroHandler);
        }
        catch (XhtmlException xhtmlError) {
            throw new AdvancedFetchMacroException("Unable to find advanced codeblocks macro by id in content: " + xhtmlError.getMessage());
        }
        if (!getParamsAndBodyMacroHandler.getFoundMatch().booleanValue()) {
            throw new AdvancedFetchMacroException("Unable to find advanced codeblocks macro by id in content.");
        }
        return getParamsAndBodyMacroHandler.getParameters();
    }
}

