/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.rest;

import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import io.codeclou.advanced.codeblock.macro.charmatcher.EscapeHelper;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedBaseException;
import io.codeclou.advanced.codeblock.macro.rest.base.BaseEndpoint;
import io.codeclou.advanced.codeblock.macro.rest.model.CustomResponseType;
import io.codeclou.advanced.codeblock.macro.rest.model.DownloadListApiModel;
import io.codeclou.advanced.codeblock.macro.rest.model.PageBlogOrCommentDTO;
import io.codeclou.advanced.codeblock.macro.rest.transformer.RestModelTransformer;
import io.codeclou.advanced.codeblock.macro.services.CodeBlockPageParserService;
import io.codeclou.advanced.codeblock.macro.services.LoggedInConfluenceUserService;
import io.codeclou.advanced.codeblock.macro.services.PluginLicenseService;
import io.codeclou.advanced.codeblock.macro.services.model.ErrorResponseOrPageOrCommentOrBlog;
import io.codeclou.advanced.codeblock.macro.services.model.LicenseInformation;
import io.codeclou.advanced.codeblock.macro.services.model.RawAndSections;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/download_list/")
@Component
public class DownloadListEndpoint
extends BaseEndpoint {
    private static final Logger log = LoggerFactory.getLogger(DownloadListEndpoint.class);
    private GlobalSettingsManager globalSettingsManager;
    private LoggedInConfluenceUserService loggedInConfluenceUserService;
    private CodeBlockPageParserService codeBlockPageParserService;
    private PluginLicenseService pluginLicenseService;

    @Autowired
    DownloadListEndpoint(LoggedInConfluenceUserService loggedInConfluenceUserService, GlobalSettingsManager globalSettingsManager, CodeBlockPageParserService codeBlockPageParserService, PluginLicenseService pluginLicenseService) {
        this.loggedInConfluenceUserService = loggedInConfluenceUserService;
        this.globalSettingsManager = globalSettingsManager;
        this.codeBlockPageParserService = codeBlockPageParserService;
        this.pluginLicenseService = pluginLicenseService;
    }

    @GET
    @Path(value="/xml")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response xmlList(@QueryParam(value="contentId") Long contentId, @QueryParam(value="macroId") String macroId_raw) {
        String macroId = EscapeHelper.escapeUrlParameterToPreventXss(macroId_raw);
        CustomResponseType responseType = CustomResponseType.XML;
        try {
            ErrorResponseOrPageOrCommentOrBlog errorOrPage = this.loggedInConfluenceUserService.enforceAuthenticationAndAuthorization(contentId, responseType);
            if (errorOrPage.isHasError()) {
                return errorOrPage.getResponse();
            }
            LicenseInformation licenseInformation = this.pluginLicenseService.detectLicense();
            if (licenseInformation.getLicenseErrors().booleanValue()) {
                return licenseInformation.getLicenseErrorResponse(responseType);
            }
            String baseUrl = this.globalSettingsManager.getGlobalSettings().getBaseUrl();
            try {
                PageBlogOrCommentDTO contentDTO = errorOrPage.getContent();
                RawAndSections rawAndSections = this.codeBlockPageParserService.getRawBodyAndCodeBlockSections(contentDTO, macroId);
                DownloadListApiModel listModel = DownloadListApiModel.from(rawAndSections.codeBlockSections, baseUrl, contentDTO, macroId, CustomResponseType.XML);
                RestModelTransformer transformer = new RestModelTransformer();
                return Response.ok((Object)transformer.transform_DownloadListApiModel_toXML(listModel)).build();
            }
            catch (AdvancedBaseException e) {
                return AdvancedBaseException.generateRestError(e, responseType);
            }
        }
        catch (Exception e) {
            log.error("ADVANCED-CODEBLOCKS-FATAL-ERROR - DownloadListEndpoint.xmlList()", (Object)e.getMessage());
            return this.generateFatalExceptionResponse(e, responseType);
        }
    }

    @GET
    @Path(value="/json")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response jsonList(@QueryParam(value="contentId") Long contentId, @QueryParam(value="macroId") String macroId_raw) {
        String macroId = EscapeHelper.escapeUrlParameterToPreventXss(macroId_raw);
        CustomResponseType responseType = CustomResponseType.JSON;
        try {
            ErrorResponseOrPageOrCommentOrBlog errorOrPage = this.loggedInConfluenceUserService.enforceAuthenticationAndAuthorization(contentId, responseType);
            if (errorOrPage.isHasError()) {
                return errorOrPage.getResponse();
            }
            LicenseInformation licenseInformation = this.pluginLicenseService.detectLicense();
            if (licenseInformation.getLicenseErrors().booleanValue()) {
                return licenseInformation.getLicenseErrorResponse(responseType);
            }
            String baseUrl = this.globalSettingsManager.getGlobalSettings().getBaseUrl();
            try {
                PageBlogOrCommentDTO contentDTO = errorOrPage.getContent();
                RawAndSections rawAndSections = this.codeBlockPageParserService.getRawBodyAndCodeBlockSections(contentDTO, macroId);
                DownloadListApiModel listModel = DownloadListApiModel.from(rawAndSections.codeBlockSections, baseUrl, contentDTO, macroId, CustomResponseType.JSON);
                RestModelTransformer transformer = new RestModelTransformer();
                return Response.ok((Object)transformer.transform_DownloadListApiModel_toJSON(listModel)).build();
            }
            catch (AdvancedBaseException e) {
                return AdvancedBaseException.generateRestError(e, responseType);
            }
        }
        catch (Exception e) {
            log.error("ADVANCED-CODEBLOCKS-FATAL-ERROR - DownloadListEndpoint.jsonList()", (Object)e.getMessage());
            return this.generateFatalExceptionResponse(e, responseType);
        }
    }
}

