/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.parser;

import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedEmptyMacroBodyException;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedInvalidMacroBodyException;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedMacroBodyProcessingException;
import io.codeclou.advanced.codeblock.macro.helper.AssertUtils;
import io.codeclou.advanced.codeblock.macro.parser.model.CodeBlockSection;
import io.codeclou.advanced.codeblock.macro.parser.model.ConfigAndContentUnparsed;
import io.codeclou.advanced.codeblock.macro.rest.model.DownloadConfigApiModel;
import io.codeclou.advanced.codeblock.macro.rest.model.DownloadConfigSectionApiModel;
import io.codeclou.advanced.codeblock.macro.rest.model.DownloadConfigSectionItemApiModel;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;

public class AdvancedCodeBlocksMacroBodyParser {
    public static ConfigAndContentUnparsed splitMacroBodyIntoContentAndConfig(String configWithContent) throws AdvancedInvalidMacroBodyException, AdvancedEmptyMacroBodyException, AdvancedMacroBodyProcessingException {
        if (AssertUtils.isNullOrEmptyOrTrimmedEmpty(configWithContent).booleanValue()) {
            throw new AdvancedEmptyMacroBodyException();
        }
        String[] splitted = (configWithContent = configWithContent.replaceAll("\r\n", "\n")).split("\\[content\\]", 2);
        if (splitted.length < 2) {
            throw new AdvancedInvalidMacroBodyException("no [content] block found. Invalid format.");
        }
        String content = splitted[1];
        if (content != null) {
            content = content.replaceFirst("^\n", "");
        }
        return new ConfigAndContentUnparsed(splitted[0], content);
    }

    protected static Map<String, Map<String, String>> getIniHashMapFromConfig(String config) throws AdvancedInvalidMacroBodyException {
        INIConfiguration iniConfiguration = new INIConfiguration();
        StringReader input = new StringReader(config);
        LinkedHashMap<String, Map<String, String>> iniFileContents = new LinkedHashMap<String, Map<String, String>>();
        try {
            iniConfiguration.read(input);
            if (iniConfiguration == null) {
                throw new AdvancedInvalidMacroBodyException("config is null");
            }
            for (String section : iniConfiguration.getSections()) {
                if (section == null) continue;
                LinkedHashMap<String, String> subSectionMap = new LinkedHashMap<String, String>();
                SubnodeConfiguration confSection = iniConfiguration.getSection(section);
                if (confSection == null) continue;
                Iterator<String> keyIterator = confSection.getKeys();
                while (keyIterator.hasNext()) {
                    String key = keyIterator.next();
                    String value = confSection.getProperty(key) != null ? confSection.getProperty(key).toString() : null;
                    String keyReplaced = key.replace("..", ".");
                    subSectionMap.put(keyReplaced, value);
                }
                iniFileContents.put(section, subSectionMap);
            }
            if (iniFileContents.isEmpty()) {
                throw new AdvancedInvalidMacroBodyException("No sections in config");
            }
            return iniFileContents;
        }
        catch (Exception e) {
            AdvancedInvalidMacroBodyException doThrow = new AdvancedInvalidMacroBodyException("Error parsing config sections.");
            doThrow.setExtraMessage(e.getMessage());
            throw doThrow;
        }
    }

    public static DownloadConfigApiModel getSectionsWithVariables(String config) throws AdvancedInvalidMacroBodyException {
        if (AssertUtils.isNullOrEmptyOrTrimmedEmpty(config).booleanValue()) {
            throw new AdvancedInvalidMacroBodyException("Error parsing config sections from null.");
        }
        DownloadConfigApiModel ret = new DownloadConfigApiModel();
        ArrayList<DownloadConfigSectionApiModel> sectionsWithVariables = new ArrayList<DownloadConfigSectionApiModel>();
        ret.setSections(sectionsWithVariables);
        Map<String, Map<String, String>> iniFileContents = AdvancedCodeBlocksMacroBodyParser.getIniHashMapFromConfig(config);
        if (iniFileContents != null && iniFileContents.entrySet() != null) {
            for (Map.Entry<String, Map<String, String>> rootSection : iniFileContents.entrySet()) {
                DownloadConfigSectionApiModel configSection = new DownloadConfigSectionApiModel();
                if (rootSection != null && rootSection.getValue() != null && rootSection.getValue().entrySet() != null) {
                    for (Map.Entry<String, String> entry : rootSection.getValue().entrySet()) {
                        configSection.getVariables().add(new DownloadConfigSectionItemApiModel(entry.getKey(), entry.getValue()));
                    }
                }
                configSection.setName(rootSection.getKey());
                configSection.setKey(AdvancedCodeBlocksMacroBodyParser.base64Encode(rootSection.getKey()));
                sectionsWithVariables.add(configSection);
            }
        }
        return ret;
    }

    public static List<CodeBlockSection> parseConfigWithContent(ConfigAndContentUnparsed configAndContentUnparsed) throws AdvancedInvalidMacroBodyException, AdvancedEmptyMacroBodyException {
        ArrayList<CodeBlockSection> codeBlockSections = new ArrayList<CodeBlockSection>();
        if (AssertUtils.isNullOrEmptyOrTrimmedEmpty(configAndContentUnparsed.contentUnparsed).booleanValue()) {
            throw new AdvancedEmptyMacroBodyException();
        }
        Map<String, Map<String, String>> iniFileContents = AdvancedCodeBlocksMacroBodyParser.getIniHashMapFromConfig(configAndContentUnparsed.configUnparsed);
        if (iniFileContents != null && iniFileContents.entrySet() != null) {
            for (Map.Entry<String, Map<String, String>> rootSection : iniFileContents.entrySet()) {
                StringBuilder strbuilder = new StringBuilder();
                if (rootSection == null || rootSection.getValue() == null || rootSection.getValue().entrySet() == null) continue;
                Set<Map.Entry<String, String>> entrySet = rootSection.getValue().entrySet();
                String currentContent = configAndContentUnparsed.contentUnparsed;
                for (Map.Entry<String, String> entry : entrySet) {
                    currentContent = currentContent.replace("${" + entry.getKey() + "}", entry.getValue());
                }
                strbuilder.append(currentContent);
                String finalcode = strbuilder.toString();
                codeBlockSections.add(new CodeBlockSection(rootSection.getKey(), AdvancedCodeBlocksMacroBodyParser.base64Encode(rootSection.getKey()), finalcode));
            }
        }
        return codeBlockSections;
    }

    public static String base64Encode(String sectionName) {
        return new String(Base64.encodeBase64(sectionName.getBytes()));
    }

    public static String base64decode(String encodedSectionName) throws UnsupportedEncodingException {
        return new String(Base64.decodeBase64(encodedSectionName), StandardCharsets.UTF_8);
    }
}

