/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.services;

import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeBlockCache;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeblockCacheKey;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeblockCacheService;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeblockMacroPreviewCacheKey;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeblockMacroPreviewCacheService;
import io.codeclou.advanced.codeblock.macro.charmatcher.AdvancedCharMatcherHelper;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedBaseException;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedEmptyMacroBodyException;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedNoSectionForKeyException;
import io.codeclou.advanced.codeblock.macro.helper.AssertUtils;
import io.codeclou.advanced.codeblock.macro.macro.fetcher.FetchingMacroDefinitionHandler;
import io.codeclou.advanced.codeblock.macro.macro.fetcher.MacroBodyAndParams;
import io.codeclou.advanced.codeblock.macro.parser.AdvancedCodeBlocksMacroBodyParser;
import io.codeclou.advanced.codeblock.macro.parser.model.CodeBlockSection;
import io.codeclou.advanced.codeblock.macro.parser.model.ConfigAndContentUnparsed;
import io.codeclou.advanced.codeblock.macro.rest.model.DownloadConfigApiModel;
import io.codeclou.advanced.codeblock.macro.rest.model.PageBlogOrCommentDTO;
import io.codeclou.advanced.codeblock.macro.services.LoggedInConfluenceUserService;
import io.codeclou.advanced.codeblock.macro.services.model.RawAndSections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CodeBlockPageParserService {
    private FetchingMacroDefinitionHandler fetchingMacroDefinitionHandler;
    private LoggedInConfluenceUserService loggedInConfluenceUserService;
    private AdvancedCodeblockCacheService advancedCodeblockCacheService;
    private AdvancedCodeblockMacroPreviewCacheService advancedCodeblockMacroPreviewCacheService;

    @Autowired
    CodeBlockPageParserService(FetchingMacroDefinitionHandler fetchingMacroDefinitionHandler, LoggedInConfluenceUserService loggedInConfluenceUserService, AdvancedCodeblockCacheService advancedCodeblockCacheService, AdvancedCodeblockMacroPreviewCacheService advancedCodeblockMacroPreviewCacheService) {
        this.fetchingMacroDefinitionHandler = fetchingMacroDefinitionHandler;
        this.loggedInConfluenceUserService = loggedInConfluenceUserService;
        this.advancedCodeblockCacheService = advancedCodeblockCacheService;
        this.advancedCodeblockMacroPreviewCacheService = advancedCodeblockMacroPreviewCacheService;
    }

    public DownloadConfigApiModel getConfigSectionsWithVariables(PageBlogOrCommentDTO content, String macroId) throws Exception {
        MacroBodyAndParams macroBodyAndParams = null;
        macroBodyAndParams = macroId.startsWith("AC-PREVIEW-") ? this.advancedCodeblockMacroPreviewCacheService.getFromCache(new AdvancedCodeblockMacroPreviewCacheKey(content.getContentId(), macroId)) : this.fetchingMacroDefinitionHandler.getMacroParametersAndBodyById(content, macroId);
        if (macroBodyAndParams != null) {
            if ("AC".equals(macroBodyAndParams.macroType)) {
                ConfigAndContentUnparsed configAndContentUnparsed = AdvancedCodeBlocksMacroBodyParser.splitMacroBodyIntoContentAndConfig(macroBodyAndParams.macroBody);
                DownloadConfigApiModel ret = AdvancedCodeBlocksMacroBodyParser.getSectionsWithVariables(configAndContentUnparsed.configUnparsed);
                ret.raw = configAndContentUnparsed.contentUnparsed;
                return ret;
            }
            if ("ACR".equals(macroBodyAndParams.macroType)) {
                if (AssertUtils.isNullOrEmptyOrTrimmedEmpty(macroBodyAndParams.macroBody).booleanValue()) {
                    throw new AdvancedEmptyMacroBodyException();
                }
                DownloadConfigApiModel ret = AdvancedCodeBlocksMacroBodyParser.getSectionsWithVariables(macroBodyAndParams.macroBody);
                AdvancedCodeBlockCache cache = this.advancedCodeblockCacheService.getFromCacheOrDownload(new AdvancedCodeblockCacheKey(content.getContentId(), macroId), (String)macroBodyAndParams.macroParameters.get("remotefileurl"), (String)macroBodyAndParams.macroParameters.get("remotefilehttpuser"), (String)macroBodyAndParams.macroParameters.get("remotefilehttppassword"));
                ret.raw = cache.getRemoteFileContent();
                ret.lastCacheUpdate = this.loggedInConfluenceUserService.getUtcIsoDateString(cache.getCreated());
                return ret;
            }
            if ("ACS".equals(macroBodyAndParams.macroType)) {
                if (AssertUtils.isNullOrEmptyOrTrimmedEmpty(macroBodyAndParams.macroBody).booleanValue()) {
                    throw new AdvancedEmptyMacroBodyException();
                }
                return DownloadConfigApiModel.ACS_DOWNLOAD_MODEL(macroBodyAndParams.macroBody);
            }
        }
        return new DownloadConfigApiModel();
    }

    public RawAndSections getRawBodyAndCodeBlockSections(PageBlogOrCommentDTO content, String macroId) throws AdvancedBaseException {
        MacroBodyAndParams macroBodyAndParams = this.fetchingMacroDefinitionHandler.getMacroParametersAndBodyById(content, macroId);
        List<CodeBlockSection> codeBlockSections = null;
        String rawContent = null;
        if ("AC".equals(macroBodyAndParams.macroType)) {
            ConfigAndContentUnparsed configAndContentUnparsed = AdvancedCodeBlocksMacroBodyParser.splitMacroBodyIntoContentAndConfig(macroBodyAndParams.macroBody);
            rawContent = configAndContentUnparsed.contentUnparsed;
            codeBlockSections = AdvancedCodeBlocksMacroBodyParser.parseConfigWithContent(configAndContentUnparsed);
        } else if ("ACR".equals(macroBodyAndParams.macroType)) {
            if (AssertUtils.isNullOrEmptyOrTrimmedEmpty(macroBodyAndParams.macroBody).booleanValue()) {
                throw new AdvancedEmptyMacroBodyException();
            }
            AdvancedCodeBlockCache cache = this.advancedCodeblockCacheService.getFromCacheOrDownload(new AdvancedCodeblockCacheKey(content.getContentId(), macroId), (String)macroBodyAndParams.macroParameters.get("remotefileurl"), (String)macroBodyAndParams.macroParameters.get("remotefilehttpuser"), (String)macroBodyAndParams.macroParameters.get("remotefilehttppassword"));
            rawContent = cache.getRemoteFileContent();
            codeBlockSections = AdvancedCodeBlocksMacroBodyParser.parseConfigWithContent(new ConfigAndContentUnparsed(macroBodyAndParams.macroBody, rawContent));
        } else {
            if (AssertUtils.isNullOrEmptyOrTrimmedEmpty(macroBodyAndParams.macroBody).booleanValue()) {
                throw new AdvancedEmptyMacroBodyException();
            }
            rawContent = macroBodyAndParams.macroBody;
        }
        return new RawAndSections(rawContent, macroBodyAndParams, codeBlockSections);
    }

    public String getRawOrSectionBodyPlainText(PageBlogOrCommentDTO content, String macroId, String sectionKey, Boolean asciiOnly) throws AdvancedBaseException {
        RawAndSections rawAndSections = this.getRawBodyAndCodeBlockSections(content, macroId);
        String replacedBody = null;
        if ("cmF3".equals(sectionKey)) {
            replacedBody = rawAndSections.rawBody;
        } else {
            CodeBlockSection foundSection = null;
            if (AssertUtils.notNullAndNotEmptyList(rawAndSections.codeBlockSections)) {
                foundSection = rawAndSections.codeBlockSections.stream().filter(x -> x.sectionTitleBase64.equalsIgnoreCase(sectionKey)).findFirst().orElse(null);
            }
            if (foundSection != null) {
                replacedBody = foundSection.sectionBody;
            }
        }
        if (replacedBody == null) {
            throw new AdvancedNoSectionForKeyException("No section found for given key: " + sectionKey);
        }
        if (asciiOnly.booleanValue()) {
            replacedBody = AdvancedCharMatcherHelper.onlyRetainAsciiAndAlloweChars(replacedBody, "\u00d6\u00c4\u00dc\u00e4\u00f6\u00fc\u00df");
        }
        return replacedBody;
    }
}

