/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.rest.model;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.Page;

public class PageBlogOrCommentDTO {
    private String bodyAsXhtmlStorageFormat;
    private Long contentId;
    private String spaceKey;
    private String contentTitle;
    private String contentType;

    public PageBlogOrCommentDTO() {
    }

    public PageBlogOrCommentDTO(Content content) {
        try {
            this.bodyAsXhtmlStorageFormat = ((ContentBody)content.getBody().get(ContentRepresentation.STORAGE)).getValue();
            this.contentId = content.getId().asLong();
            this.contentType = content.getType().getType();
            this.spaceKey = content.getSpace().getKey();
            this.contentTitle = content.getTitle();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PageBlogOrCommentDTO(Page page) {
        try {
            this.bodyAsXhtmlStorageFormat = page.getBodyAsString();
            this.contentId = page.getId();
            this.contentType = page.getType();
            this.spaceKey = page.getSpaceKey();
            this.contentTitle = page.getTitle();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PageBlogOrCommentDTO(Comment comment) {
        try {
            this.bodyAsXhtmlStorageFormat = comment.getBodyAsString();
            this.contentId = comment.getId();
            this.contentType = comment.getType();
            this.spaceKey = comment.getSpaceKey();
            this.contentTitle = comment.getTitle();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PageBlogOrCommentDTO(BlogPost blogPost) {
        try {
            this.bodyAsXhtmlStorageFormat = blogPost.getBodyAsString();
            this.contentId = blogPost.getId();
            this.contentType = blogPost.getType();
            this.spaceKey = blogPost.getSpaceKey();
            this.contentTitle = blogPost.getTitle();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PageBlogOrCommentDTO(Draft draft) {
        try {
            this.bodyAsXhtmlStorageFormat = draft.getBodyAsString();
            this.contentId = draft.getId();
            this.contentType = draft.getType();
            this.spaceKey = draft.getDraftSpaceKey();
            this.contentTitle = draft.getTitle();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getBodyAsXhtmlStorageFormat() {
        return this.bodyAsXhtmlStorageFormat;
    }

    public void setBodyAsXhtmlStorageFormat(String bodyAsXhtmlStorageFormat) {
        this.bodyAsXhtmlStorageFormat = bodyAsXhtmlStorageFormat;
    }

    public Long getContentId() {
        return this.contentId;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getContentTitle() {
        return this.contentTitle;
    }

    public void setContentTitle(String contentTitle) {
        this.contentTitle = contentTitle;
    }
}

