/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import io.codeclou.advanced.codeblock.macro.charmatcher.EscapeHelper;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedBaseException;
import io.codeclou.advanced.codeblock.macro.rest.base.BaseEndpoint;
import io.codeclou.advanced.codeblock.macro.rest.model.CustomResponseType;
import io.codeclou.advanced.codeblock.macro.rest.model.DownloadConfigApiModel;
import io.codeclou.advanced.codeblock.macro.services.CodeBlockPageParserService;
import io.codeclou.advanced.codeblock.macro.services.LoggedInConfluenceUserService;
import io.codeclou.advanced.codeblock.macro.services.PluginLicenseService;
import io.codeclou.advanced.codeblock.macro.services.model.ErrorResponseOrPageOrCommentOrBlog;
import io.codeclou.advanced.codeblock.macro.services.model.LicenseInformation;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/download_config/")
@Component
public class DownloadConfigEndpoint
extends BaseEndpoint {
    private static final Logger log = LoggerFactory.getLogger(DownloadConfigEndpoint.class);
    private LoggedInConfluenceUserService loggedInConfluenceUserService;
    private CodeBlockPageParserService codeBlockPageParserService;
    private PluginLicenseService pluginLicenseService;

    @Autowired
    DownloadConfigEndpoint(LoggedInConfluenceUserService loggedInConfluenceUserService, CodeBlockPageParserService codeBlockPageParserService, PluginLicenseService pluginLicenseService) {
        this.loggedInConfluenceUserService = loggedInConfluenceUserService;
        this.codeBlockPageParserService = codeBlockPageParserService;
        this.pluginLicenseService = pluginLicenseService;
    }

    @GET
    @Path(value="/json")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response configDownload(@QueryParam(value="contentId") Long contentId, @QueryParam(value="macroId") String macroId_raw) {
        String macroId = EscapeHelper.escapeUrlParameterToPreventXss(macroId_raw);
        CustomResponseType responseType = CustomResponseType.JSON;
        try {
            ErrorResponseOrPageOrCommentOrBlog errorOrPage = this.loggedInConfluenceUserService.enforceAuthenticationAndAuthorization(contentId, responseType);
            if (errorOrPage.isHasError()) {
                return errorOrPage.getResponse();
            }
            LicenseInformation licenseInformation = this.pluginLicenseService.detectLicense();
            if (licenseInformation.getLicenseErrors().booleanValue()) {
                return licenseInformation.getLicenseErrorResponse(responseType);
            }
            try {
                DownloadConfigApiModel configSections = this.codeBlockPageParserService.getConfigSectionsWithVariables(errorOrPage.getContent(), macroId);
                return Response.ok((Object)configSections).build();
            }
            catch (AdvancedBaseException e) {
                return AdvancedBaseException.generateRestError(e, responseType);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return this.generateFatalExceptionResponse(e, responseType);
        }
    }
}

