/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import io.codeclou.advanced.codeblock.macro.charmatcher.EscapeHelper;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedBaseException;
import io.codeclou.advanced.codeblock.macro.rest.base.BaseEndpoint;
import io.codeclou.advanced.codeblock.macro.rest.model.CustomResponseType;
import io.codeclou.advanced.codeblock.macro.services.CodeBlockPageParserService;
import io.codeclou.advanced.codeblock.macro.services.LoggedInConfluenceUserService;
import io.codeclou.advanced.codeblock.macro.services.PluginLicenseService;
import io.codeclou.advanced.codeblock.macro.services.model.ErrorResponseOrPageOrCommentOrBlog;
import io.codeclou.advanced.codeblock.macro.services.model.LicenseInformation;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/download_code/")
@Component
public class DownloadCodeBlockEndpoint
extends BaseEndpoint {
    private static final Logger log = LoggerFactory.getLogger(DownloadCodeBlockEndpoint.class);
    private LoggedInConfluenceUserService loggedInConfluenceUserService;
    private CodeBlockPageParserService codeBlockPageParserService;
    private PluginLicenseService pluginLicenseService;

    @Autowired
    DownloadCodeBlockEndpoint(LoggedInConfluenceUserService loggedInConfluenceUserService, CodeBlockPageParserService codeBlockPageParserService, PluginLicenseService pluginLicenseService) {
        this.loggedInConfluenceUserService = loggedInConfluenceUserService;
        this.codeBlockPageParserService = codeBlockPageParserService;
        this.pluginLicenseService = pluginLicenseService;
    }

    @GET
    @Path(value="/plain_text")
    @Consumes(value={"text/plain; charset=UTF-8"})
    @Produces(value={"text/plain; charset=UTF-8"})
    @AnonymousAllowed
    public Response codeBlockDownload(@QueryParam(value="contentId") Long contentId, @QueryParam(value="macroId") String macroId_raw, @QueryParam(value="key") String key_raw, @QueryParam(value="asciiOnly") boolean asciiOnly) {
        String macroId = EscapeHelper.escapeUrlParameterToPreventXss(macroId_raw);
        String key = EscapeHelper.escapeUrlParameterToPreventXss(key_raw);
        CustomResponseType responseType = CustomResponseType.PLAIN_TEXT;
        try {
            ErrorResponseOrPageOrCommentOrBlog errorOrContent = this.loggedInConfluenceUserService.enforceAuthenticationAndAuthorization(contentId, responseType);
            if (errorOrContent.isHasError()) {
                return errorOrContent.getResponse();
            }
            LicenseInformation licenseInformation = this.pluginLicenseService.detectLicense();
            if (licenseInformation.getLicenseErrors().booleanValue()) {
                return licenseInformation.getLicenseErrorResponse(responseType);
            }
            try {
                String plainTextBody = this.codeBlockPageParserService.getRawOrSectionBodyPlainText(errorOrContent.getContent(), macroId, key, asciiOnly);
                return Response.ok((Object)plainTextBody).build();
            }
            catch (AdvancedBaseException e) {
                return AdvancedBaseException.generateRestError(e, responseType);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return this.generateFatalExceptionResponse(e, responseType);
        }
    }
}

