/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.parser;

import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedEmptyMacroBodyException;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedInvalidMacroBodyException;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedMacroBodyProcessingException;
import io.codeclou.advanced.codeblock.macro.helper.AssertUtils;
import io.codeclou.advanced.codeblock.macro.parser.model.CodeBlockSection;
import io.codeclou.advanced.codeblock.macro.parser.model.ConfigAndContentUnparsed;
import io.codeclou.advanced.codeblock.macro.rest.model.DownloadConfigApiModel;
import io.codeclou.advanced.codeblock.macro.rest.model.DownloadConfigSectionApiModel;
import io.codeclou.advanced.codeblock.macro.rest.model.DownloadConfigSectionItemApiModel;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class AdvancedCodeBlocksMacroBodyParser {
    public static ConfigAndContentUnparsed splitMacroBodyIntoContentAndConfig(String configWithContent) throws AdvancedInvalidMacroBodyException, AdvancedEmptyMacroBodyException, AdvancedMacroBodyProcessingException {
        if (AssertUtils.isNullOrEmptyOrTrimmedEmpty(configWithContent).booleanValue()) {
            throw new AdvancedEmptyMacroBodyException();
        }
        String[] splitted = (configWithContent = configWithContent.replaceAll("\r\n", "\n")).split("\\[content\\]", 2);
        if (splitted.length < 2) {
            throw new AdvancedInvalidMacroBodyException("no [content] block found. Invalid format.");
        }
        String content = splitted[1];
        if (content != null) {
            content = content.replaceFirst("^\n", "");
        }
        return new ConfigAndContentUnparsed(splitted[0], content);
    }

    public static DownloadConfigApiModel getSectionsWithVariables(String config) throws AdvancedInvalidMacroBodyException {
        if (AssertUtils.isNullOrEmptyOrTrimmedEmpty(config).booleanValue()) {
            throw new AdvancedInvalidMacroBodyException("Error parsing config sections from null.");
        }
        DownloadConfigApiModel ret = new DownloadConfigApiModel();
        ArrayList<DownloadConfigSectionApiModel> sectionsWithVariables = new ArrayList<DownloadConfigSectionApiModel>();
        ret.sections = sectionsWithVariables;
        Ini ini = new Ini();
        StringReader input = new StringReader(config);
        try {
            ini.load(input);
        }
        catch (Exception e) {
            AdvancedInvalidMacroBodyException doThrow = new AdvancedInvalidMacroBodyException("Error parsing config sections.");
            doThrow.setExtraMessage(e.getMessage());
            throw doThrow;
        }
        Set sections = ini.keySet();
        for (String sectionName : sections) {
            DownloadConfigSectionApiModel configSection = new DownloadConfigSectionApiModel();
            Profile.Section currentsection = (Profile.Section)ini.get(sectionName);
            Set entrySet = currentsection.entrySet();
            for (Map.Entry entry : entrySet) {
                configSection.variables.add(new DownloadConfigSectionItemApiModel((String)entry.getKey(), (String)entry.getValue()));
            }
            configSection.name = sectionName;
            configSection.key = AdvancedCodeBlocksMacroBodyParser.base64Encode(sectionName);
            sectionsWithVariables.add(configSection);
        }
        return ret;
    }

    public static List<CodeBlockSection> parseConfigWithContent(ConfigAndContentUnparsed configAndContentUnparsed) throws AdvancedInvalidMacroBodyException, AdvancedEmptyMacroBodyException {
        ArrayList<CodeBlockSection> codeBlockSections = new ArrayList<CodeBlockSection>();
        Ini ini = new Ini();
        if (AssertUtils.isNullOrEmptyOrTrimmedEmpty(configAndContentUnparsed.contentUnparsed).booleanValue()) {
            throw new AdvancedEmptyMacroBodyException();
        }
        StringReader input = new StringReader(configAndContentUnparsed.configUnparsed);
        try {
            ini.load(input);
        }
        catch (Exception e) {
            AdvancedInvalidMacroBodyException doThrow = new AdvancedInvalidMacroBodyException("Error parsing config sections");
            doThrow.setExtraMessage(e.getMessage());
            throw doThrow;
        }
        Set sections = ini.keySet();
        for (String sectionName : sections) {
            StringBuilder strbuilder = new StringBuilder();
            Profile.Section currentsection = (Profile.Section)ini.get(sectionName);
            Set entrySet = currentsection.entrySet();
            String currentContent = configAndContentUnparsed.contentUnparsed;
            for (Map.Entry entry : entrySet) {
                currentContent = currentContent.replace("${" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
            }
            strbuilder.append(currentContent);
            String finalcode = strbuilder.toString();
            codeBlockSections.add(new CodeBlockSection(sectionName, AdvancedCodeBlocksMacroBodyParser.base64Encode(sectionName), finalcode));
        }
        return codeBlockSections;
    }

    public static String base64Encode(String sectionName) {
        return new String(Base64.encodeBase64((byte[])sectionName.getBytes()));
    }

    public static String base64decode(String encodedSectionName) throws UnsupportedEncodingException {
        return new String(Base64.decodeBase64((String)encodedSectionName), StandardCharsets.UTF_8);
    }
}

