/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.services;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import io.codeclou.advanced.codeblock.macro.rest.model.CustomResponseType;
import io.codeclou.advanced.codeblock.macro.rest.model.RestErrorModel;
import io.codeclou.advanced.codeblock.macro.services.ContentAndPermissionService;
import io.codeclou.advanced.codeblock.macro.services.model.ErrorResponseOrPageOrCommentOrBlog;
import io.codeclou.advanced.codeblock.macro.services.model.HasPermissionAndContent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoggedInConfluenceUserService {
    private UserManager userManager;
    private UserAccessor userAccessor;
    private ContentAndPermissionService contentOrDraftService;

    @Autowired
    public LoggedInConfluenceUserService(UserManager userManager, UserAccessor userAccessor, ContentAndPermissionService contentOrDraftService) {
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.contentOrDraftService = contentOrDraftService;
    }

    public ErrorResponseOrPageOrCommentOrBlog enforceAuthenticationAndAuthorization(Long contentId, CustomResponseType type) {
        ErrorResponseOrPageOrCommentOrBlog returnObj = new ErrorResponseOrPageOrCommentOrBlog();
        User confluenceUser = this.getLoggedInUser();
        if (confluenceUser != null) {
            HasPermissionAndContent permissionAndContent = this.contentOrDraftService.findContentByIdAndCheckPermission(contentId, confluenceUser);
            returnObj.setContent(permissionAndContent.getContent());
            returnObj.setHasError(permissionAndContent.getUserHasPermissionOnContent() == false);
            if (!permissionAndContent.getUserHasPermissionOnContent().booleanValue()) {
                RestErrorModel error = new RestErrorModel("403_FORBIDDEN", "You do not have read permission for this page, blog, comment or draft.", "contentId = " + contentId.toString());
                error.errorCode = "AUTH";
                returnObj.setResponse(Response.ok((Object)error.toExternalFormByType(type)).status(Response.Status.FORBIDDEN).build());
                returnObj.setContent(null);
                returnObj.setHasError(true);
            }
            return returnObj;
        }
        RestErrorModel error = new RestErrorModel("401_UNAUTHORIZED", "You are not logged in.", null);
        error.errorCode = "AUTH";
        returnObj.setResponse(Response.ok((Object)error.toExternalFormByType(type)).status(Response.Status.UNAUTHORIZED).build());
        returnObj.setContent(null);
        returnObj.setHasError(true);
        return returnObj;
    }

    public User getLoggedInUser() {
        String username = null;
        try {
            ConfluenceUser confluenceUser = this.getLoggedInConfluenceUser();
            if (confluenceUser != null) {
                username = confluenceUser.getName();
            }
            if (username != null) {
                return this.userManager.getUser(username);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected ConfluenceUser getLoggedInConfluenceUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    public String getRemoteUserTimeZone() {
        ConfluenceUserPreferences preferences;
        ConfluenceUser user = this.getLoggedInConfluenceUser();
        if (user != null && (preferences = this.userAccessor.getConfluenceUserPreferences((User)user)) != null && preferences.getTimeZone() != null) {
            return preferences.getTimeZone().getID();
        }
        return "";
    }

    public String getRemoteUserLocale() {
        ConfluenceUserPreferences preferences;
        ConfluenceUser user = this.getLoggedInConfluenceUser();
        if (user != null && (preferences = this.userAccessor.getConfluenceUserPreferences((User)user)) != null && preferences.getLocale() != null) {
            return preferences.getLocale().toLanguageTag();
        }
        return "";
    }

    public String getUtcIsoDateString(Date d) {
        if (d != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'+0000'", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format.format(d);
        }
        return "1970-01-01T04:20:00+0000";
    }
}

