/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.services;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.content.service.BlogPostService;
import com.atlassian.confluence.content.service.DraftService;
import com.atlassian.confluence.content.service.blogpost.BlogPostLocator;
import com.atlassian.confluence.core.service.NotValidException;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import io.codeclou.advanced.codeblock.macro.rest.model.PageBlogOrCommentDTO;
import io.codeclou.advanced.codeblock.macro.services.model.HasPermissionAndContent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContentAndPermissionService {
    private final ContentService contentService;
    private final DraftService draftService;
    private final PermissionManager permissionManager;
    private final CommentManager commentManager;
    private final PageManager pageManager;
    private final BlogPostService blogPostService;

    @Autowired
    public ContentAndPermissionService(@ComponentImport ContentService contentService, @ComponentImport DraftService draftService, @ComponentImport BlogPostService blogPostService, @ComponentImport CommentManager commentManager, @ComponentImport PageManager pageManager, @ComponentImport PermissionManager permissionManager) {
        this.contentService = contentService;
        this.draftService = draftService;
        this.pageManager = pageManager;
        this.commentManager = commentManager;
        this.blogPostService = blogPostService;
        this.permissionManager = permissionManager;
    }

    public HasPermissionAndContent findContentByIdAndCheckPermission(Long contentId, User confluenceUser) {
        Draft draft;
        BlogPost blogPost;
        Comment comment;
        Page page;
        Content content = this.contentService.find(new Expansion[]{new Expansion("body", new Expansions(new Expansion[]{new Expansion(ContentRepresentation.STORAGE.getRepresentation())})), new Expansion("space"), new Expansion("metadata")}).withType(new ContentType[]{ContentType.BLOG_POST, ContentType.COMMENT, ContentType.PAGE}).withId(ContentId.of((long)contentId), new ContentId[0]).fetch().orElse(null);
        boolean hasPermission = false;
        PageBlogOrCommentDTO dto = null;
        if (content != null && content.getType().equals((Object)ContentType.PAGE) && (page = this.getPageById(contentId)) != null) {
            hasPermission = this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, (Object)page);
            dto = new PageBlogOrCommentDTO(page);
        }
        if (content != null && content.getType().equals((Object)ContentType.COMMENT) && (comment = this.getCommentById(contentId)) != null) {
            hasPermission = this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, (Object)comment);
            dto = new PageBlogOrCommentDTO(comment);
        }
        if (content != null && content.getType().equals((Object)ContentType.BLOG_POST) && (blogPost = this.getBlogPost(contentId)) != null) {
            hasPermission = this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, (Object)blogPost);
            dto = new PageBlogOrCommentDTO(blogPost);
        }
        if (content == null && (draft = this.findDraftByIdOrNull(contentId)) != null) {
            hasPermission = this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, (Object)draft);
            dto = new PageBlogOrCommentDTO(draft);
        }
        return new HasPermissionAndContent(hasPermission, dto);
    }

    public Page getPageById(Long pageId) {
        return this.pageManager.getPage(pageId.longValue());
    }

    public Comment getCommentById(Long pageId) {
        return this.commentManager.getComment(pageId.longValue());
    }

    public BlogPost getBlogPost(Long pageId) {
        BlogPostLocator bl = this.blogPostService.getIdBlogPostLocator(pageId.longValue());
        if (bl != null) {
            return bl.getBlogPost();
        }
        return null;
    }

    public Draft findDraftByIdOrNull(Long contentId) {
        try {
            return this.draftService.getDraft(contentId.longValue());
        }
        catch (NotValidException notValidException) {
            return null;
        }
    }
}

