/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.rest.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedBaseException;
import io.codeclou.advanced.codeblock.macro.rest.model.CustomResponseType;
import io.codeclou.advanced.codeblock.macro.services.model.LicenseInformation;
import org.apache.commons.lang.StringEscapeUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class RestErrorModel {
    @JsonProperty
    public String error;
    @JsonProperty
    public String errorCode;
    @JsonProperty
    public String message;
    @JsonProperty
    public String extraMessage;

    RestErrorModel() {
    }

    public RestErrorModel(String error, String message, String extraMessage) {
        this.error = error;
        this.message = message;
        this.extraMessage = extraMessage;
        this.errorCode = null;
    }

    public RestErrorModel(LicenseInformation licenseInformation) {
        this.error = "500_ERROR_LICENSE_EXCEPTION";
        this.message = licenseInformation.getLicenseErrorMessage();
        this.extraMessage = null;
        this.errorCode = licenseInformation.getLicenseErrorType();
    }

    public RestErrorModel(AdvancedBaseException e) {
        this.error = e.getRestExceptionKey();
        this.message = e.getMessage();
        this.extraMessage = e.getExtraMessage();
        this.errorCode = e.getErrorCode();
    }

    public String toExternalFormByType(CustomResponseType type) {
        if (type == CustomResponseType.XML) {
            return this.toXML();
        }
        if (type == CustomResponseType.JSON) {
            return this.toJSON();
        }
        return this.toPLAIN_TEXT();
    }

    public String toXML() {
        StringBuilder stb = new StringBuilder();
        stb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stb.append("<advancedCodeblockMacro>");
        stb.append("  <error>" + StringEscapeUtils.escapeXml((String)this.error) + "</error>");
        stb.append("  <message>" + StringEscapeUtils.escapeXml((String)this.message) + "</message>");
        stb.append("  <extraMessage>" + (this.extraMessage != null ? StringEscapeUtils.escapeXml((String)this.extraMessage) : "") + "</extraMessage>");
        stb.append("  <errorCode>" + (this.errorCode != null ? StringEscapeUtils.escapeXml((String)this.errorCode) : "") + "</errorCode>");
        stb.append("</advancedCodeblockMacro>");
        return stb.toString();
    }

    public String toPLAIN_TEXT() {
        StringBuilder stb = new StringBuilder();
        stb.append(this.error);
        stb.append(" ");
        stb.append("(" + this.message + ")");
        if (this.extraMessage != null) {
            stb.append("\n[" + this.extraMessage + "]");
        }
        if (this.errorCode != null) {
            stb.append("\n[errorCode:" + this.errorCode + "]");
        }
        return stb.toString();
    }

    public String toJSON() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return gson.toJson(this);
    }
}

