/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.rest.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.codeclou.advanced.codeblock.macro.helper.AssertUtils;
import io.codeclou.advanced.codeblock.macro.parser.DownloadUrlGenerator;
import io.codeclou.advanced.codeblock.macro.parser.model.CodeBlockSection;
import io.codeclou.advanced.codeblock.macro.rest.model.CustomResponseType;
import io.codeclou.advanced.codeblock.macro.rest.model.DownloadListCodeBlockApiModel;
import io.codeclou.advanced.codeblock.macro.rest.model.DownloadListContentApiModel;
import io.codeclou.advanced.codeblock.macro.rest.model.PageBlogOrCommentDTO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class DownloadListApiModel {
    @JsonProperty
    public DownloadListContentApiModel content = new DownloadListContentApiModel();
    @JsonProperty
    public List<DownloadListCodeBlockApiModel> codeBlocks = new ArrayList<DownloadListCodeBlockApiModel>();
    @JsonIgnore
    public String downloadCodeBaseUrl;

    public static DownloadListApiModel from(List<CodeBlockSection> codeBlockSections, String baseUrl, PageBlogOrCommentDTO contentDTO, String macroId, CustomResponseType type) {
        DownloadListApiModel model = new DownloadListApiModel();
        model.content.spaceKey = contentDTO.getSpaceKey();
        model.content.contentId = contentDTO.getContentId();
        model.content.contentType = contentDTO.getContentType();
        model.content.contentTitle = contentDTO.getContentTitle();
        model.content.macroId = macroId;
        if (AssertUtils.notNullAndNotEmptyList(codeBlockSections)) {
            for (CodeBlockSection section : codeBlockSections) {
                DownloadListCodeBlockApiModel codeBlock = new DownloadListCodeBlockApiModel();
                codeBlock.download = DownloadUrlGenerator.generateDownloadCodeBlockUrl(baseUrl, macroId, contentDTO.getContentId(), section.sectionTitleBase64, false, CustomResponseType.XML == type);
                codeBlock.key = section.sectionTitleBase64;
                codeBlock.name = section.sectionTitle;
                model.codeBlocks.add(codeBlock);
            }
        }
        DownloadListCodeBlockApiModel codeBlock = new DownloadListCodeBlockApiModel();
        codeBlock.download = DownloadUrlGenerator.generateDownloadCodeBlockUrl(baseUrl, macroId, contentDTO.getContentId(), "cmF3", false, CustomResponseType.XML == type);
        codeBlock.key = "cmF3";
        codeBlock.name = "raw";
        model.codeBlocks.add(codeBlock);
        return model;
    }

    public String toXML() {
        StringBuilder stb = new StringBuilder();
        stb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stb.append("<advancedCodeblockMacro>\n");
        stb.append("<content>\n");
        stb.append("  <contentId>" + this.content.contentId + "</contentId>\n");
        stb.append("  <contentType>" + this.content.contentType + "</contentType>\n");
        stb.append("  <contentTitle>" + StringEscapeUtils.escapeXml((String)this.content.contentTitle) + "</contentTitle>\n");
        stb.append("  <spaceKey>" + this.content.spaceKey + "</spaceKey>\n");
        stb.append("  <macroId>" + this.content.macroId + "</macroId>\n");
        stb.append("</content>\n");
        stb.append("<codeBlocks>\n");
        if (AssertUtils.notNullAndNotEmptyList(this.codeBlocks)) {
            for (DownloadListCodeBlockApiModel codeBlock : this.codeBlocks) {
                stb.append("  <codeBlock>\n");
                stb.append("    <key>" + codeBlock.key + "</key>\n");
                stb.append("    <name>" + StringEscapeUtils.escapeXml((String)codeBlock.name) + "</name>\n");
                stb.append("    <download>" + codeBlock.download + "</download>\n");
                stb.append("  </codeBlock>\n");
            }
        }
        stb.append("</codeBlocks>\n");
        stb.append("</advancedCodeblockMacro>\n");
        return stb.toString();
    }

    public String toJSON() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return gson.toJson(this);
    }
}

