/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeblockCacheKey;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeblockCacheService;
import io.codeclou.advanced.codeblock.macro.charmatcher.EscapeHelper;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedBaseException;
import io.codeclou.advanced.codeblock.macro.rest.base.BaseEndpoint;
import io.codeclou.advanced.codeblock.macro.rest.model.CacheRefreshOk;
import io.codeclou.advanced.codeblock.macro.rest.model.CustomResponseType;
import io.codeclou.advanced.codeblock.macro.services.LoggedInConfluenceUserService;
import io.codeclou.advanced.codeblock.macro.services.PluginLicenseService;
import io.codeclou.advanced.codeblock.macro.services.model.ErrorResponseOrPageOrCommentOrBlog;
import io.codeclou.advanced.codeblock.macro.services.model.LicenseInformation;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/cache/")
@Component
public class CacheRefreshEndpoint
extends BaseEndpoint {
    private static final Logger log = LoggerFactory.getLogger(CacheRefreshEndpoint.class);
    private LoggedInConfluenceUserService loggedInConfluenceUserService;
    private AdvancedCodeblockCacheService advancedCodeblockCacheService;
    private PluginLicenseService pluginLicenseService;

    @Autowired
    CacheRefreshEndpoint(LoggedInConfluenceUserService loggedInConfluenceUserService, AdvancedCodeblockCacheService advancedCodeblockCacheService, PluginLicenseService pluginLicenseService) {
        this.loggedInConfluenceUserService = loggedInConfluenceUserService;
        this.advancedCodeblockCacheService = advancedCodeblockCacheService;
        this.pluginLicenseService = pluginLicenseService;
    }

    @PUT
    @Path(value="/refresh_remote_file")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response doRefreshRemoteFile(@QueryParam(value="contentId") Long contentId, @QueryParam(value="macroId") String macroId_raw) {
        String macroId = EscapeHelper.escapeUrlParameterToPreventXss(macroId_raw);
        CustomResponseType responseType = CustomResponseType.JSON;
        try {
            ErrorResponseOrPageOrCommentOrBlog errorOrPage = this.loggedInConfluenceUserService.enforceAuthenticationAndAuthorization(contentId, responseType);
            if (errorOrPage.isHasError()) {
                return errorOrPage.getResponse();
            }
            LicenseInformation licenseInformation = this.pluginLicenseService.detectLicense();
            if (licenseInformation.getLicenseErrors().booleanValue()) {
                return licenseInformation.getLicenseErrorResponse(responseType);
            }
            try {
                this.advancedCodeblockCacheService.removeFromCache(new AdvancedCodeblockCacheKey(contentId, macroId));
                return Response.ok((Object)new CacheRefreshOk()).build();
            }
            catch (AdvancedBaseException e) {
                return AdvancedBaseException.generateRestError(e, responseType);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return this.generateFatalExceptionResponse(e, responseType);
        }
    }
}

