/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.macro.base;

import com.atlassian.confluence.api.model.accessmode.AccessMode;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.sal.api.message.I18nResolver;
import io.codeclou.advanced.codeblock.macro.api.OnlineHelpLinkHelper;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeBlockMacroPreviewCache;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeblockCacheService;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeblockMacroPreviewCacheKey;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeblockMacroPreviewCacheService;
import io.codeclou.advanced.codeblock.macro.macro.base.ContextContentIdAndMacroId;
import io.codeclou.advanced.codeblock.macro.macro.fetcher.FetchingMacroDefinitionHandler;
import io.codeclou.advanced.codeblock.macro.macro.transformer.MacroContextTransformHelper;
import io.codeclou.advanced.codeblock.macro.services.LoggedInConfluenceUserService;
import io.codeclou.advanced.codeblock.macro.services.PluginLicenseService;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseAdvancedCodeblockMacro
extends BaseMacro {
    protected OnlineHelpLinkHelper onlineHelpLinkHelper;
    protected I18nResolver i18n;
    protected BootstrapManager bootstrapManager;
    protected AccessModeService accessModeService;
    protected PluginLicenseService pluginLicenseService;
    protected AdvancedCodeblockCacheService advancedCodeblockCacheService;
    protected AdvancedCodeblockMacroPreviewCacheService advancedCodeblockMacroPreviewCacheService;
    protected LoggedInConfluenceUserService loggedInConfluenceUserService;
    protected FetchingMacroDefinitionHandler fetchingMacroDefinitionHandler;
    protected WebResourceUrlProvider webResourceUrlProvider;
    protected SettingsManager settingsManager;
    private static final Logger log = LoggerFactory.getLogger(BaseAdvancedCodeblockMacro.class);
    protected static final Map<String, String> allowedSyntaxHighlighterLanguagesNew = new HashMap<String, String>();
    protected static final Map<String, String> allowedSyntaxHighlighterLanguagesBackwardCompatibility;

    protected ContextContentIdAndMacroId getContextWithParamsForAllMacros(String macroType, String renderTypeForFrontend, Map<String, String> params, String body, ConversionContext conversionContext) {
        Map<String, Object> context = this.getDefaultVelocityContext();
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        long contentId = this.getContentIdFromConversionContext(conversionContext);
        String contentType = this.getContentTypeFromConversionContext(conversionContext);
        MacroId macroId = (MacroId)macroDefinition.getMacroId().getOrElse((Object)MacroId.fromString((String)("AC-PREVIEW-" + UUID.randomUUID())));
        if (renderTypeForFrontend.equals("PREVIEW_WITH_JS_REDUCED_FEATURES") && macroId.getId().startsWith("AC-PREVIEW-")) {
            this.advancedCodeblockMacroPreviewCacheService.putToCache(new AdvancedCodeblockMacroPreviewCacheKey(contentId, macroId.getId()), AdvancedCodeBlockMacroPreviewCache.fromMacroDefinition(macroType, macroDefinition));
        }
        Boolean expandFirst = this.getBooleanOrDefaultFromParams(params, "expandFirst", false);
        String globaltitle = this.getStringOrDefaultFromParams(params, "globaltitle", null);
        Boolean enableddl = this.getBooleanOrDefaultFromParams(params, "enableddl", false);
        String lang = this.getStringOrDefaultFromParams(params, "lang", null);
        String theme = this.getStringOrDefaultFromParams(params, "theme", "light-spring");
        String remoteFileUrl = this.getStringOrDefaultFromParams(params, "remotefileurl", null);
        context.put("globaltitle", globaltitle);
        context.put("macroid", macroId.getId());
        context.put("contentid", contentId);
        context.put("contenttype", contentType);
        context.put("lang", this.getValidLanguageCssClass(lang));
        context.put("macrotype", macroType);
        context.put("enableddl", "ACR".equals(macroType) ? "true" : enableddl.toString());
        context.put("expandFirst", expandFirst.toString());
        context.put("appVersion", this.onlineHelpLinkHelper.getPluginVersion());
        context.put("timeZone", this.loggedInConfluenceUserService.getRemoteUserTimeZone());
        context.put("locale", this.loggedInConfluenceUserService.getRemoteUserLocale());
        context.put("readonlymode", this.isReadOnlyModeActive());
        context.put("theme", theme);
        context.put("rendertype", renderTypeForFrontend);
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        String webWorkerJsBundleUrl = baseUrl + this.webResourceUrlProvider.getResourceUrl("confluenceadvancedcodeblockplugin:resources-highlight-webworker", "advanced-highlight-bundle.js");
        context.put("iifewebworkerurl", webWorkerJsBundleUrl);
        context.put("remotefileurl", remoteFileUrl);
        context.put("isdraft", MacroContextTransformHelper.getIsDraftFromContentEntityObjectNullSafe(conversionContext));
        return new ContextContentIdAndMacroId(context, macroId.getId(), contentId, contentType);
    }

    public boolean isReadOnlyModeActive() {
        return AccessMode.READ_ONLY.equals((Object)this.accessModeService.getAccessMode());
    }

    public String execute(Map params, String body, RenderContext renderContext) throws MacroException {
        return null;
    }

    public RenderMode getBodyRenderMode() {
        return null;
    }

    public boolean hasBody() {
        return false;
    }

    protected boolean isValidLanguage(String lang) {
        boolean ret = false;
        if (allowedSyntaxHighlighterLanguagesBackwardCompatibility.containsKey(lang)) {
            ret = true;
        }
        if (allowedSyntaxHighlighterLanguagesNew.containsKey(lang)) {
            ret = true;
        }
        return ret;
    }

    protected String getValidLanguageCssClass(String lang) {
        if (allowedSyntaxHighlighterLanguagesBackwardCompatibility.containsKey(lang)) {
            return allowedSyntaxHighlighterLanguagesBackwardCompatibility.get(lang);
        }
        if (allowedSyntaxHighlighterLanguagesNew.containsKey(lang)) {
            return allowedSyntaxHighlighterLanguagesNew.get(lang);
        }
        return "___NO_LANG_SELECTED___";
    }

    public Map<String, Object> getDefaultVelocityContext() {
        return MacroUtils.defaultVelocityContext();
    }

    public String renderTemplate(String templateName, Map<String, Object> context) {
        return VelocityUtils.getRenderedTemplate((String)templateName, context);
    }

    public String renderErrorWithTemplate(String errorKey, String errorBody, String macroType) {
        Map<String, Object> context = this.getDefaultVelocityContext();
        context.put("errorkey", errorKey);
        context.put("errorbody", errorBody);
        context.put("macrotype", macroType);
        return this.renderTemplate("templates/advanced-codeblocks-error.vm", context);
    }

    public String i18n_getText(String key) {
        String result = key;
        result = this.i18n.getText(key);
        return result;
    }

    public OnlineHelpLinkHelper getOnlineHelpLinkHelper() {
        return this.onlineHelpLinkHelper;
    }

    protected String getStringOrDefaultFromParams(Map<String, String> params, String keyToGet, String defaultValue) {
        String ret = defaultValue;
        if (params.containsKey(keyToGet)) {
            ret = params.get(keyToGet);
        }
        return ret;
    }

    protected Boolean getBooleanOrDefaultFromParams(Map<String, String> params, String keyToGet, Boolean defaultValue) {
        Boolean ret = defaultValue;
        if (params.containsKey(keyToGet)) {
            ret = new Boolean(params.get(keyToGet));
        }
        return ret;
    }

    protected long getContentIdFromConversionContext(ConversionContext conversionContext) {
        long contentId = -1L;
        if (conversionContext.getEntity() != null) {
            contentId = conversionContext.getEntity().getId();
        }
        return contentId;
    }

    protected String getContentTypeFromConversionContext(ConversionContext conversionContext) {
        String type = "none";
        if (conversionContext.getEntity() != null) {
            type = conversionContext.getEntity().getType();
        }
        return type;
    }

    static {
        allowedSyntaxHighlighterLanguagesNew.put("1C", "1c");
        allowedSyntaxHighlighterLanguagesNew.put("ABNF", "abnf");
        allowedSyntaxHighlighterLanguagesNew.put("Access logs", "accesslog");
        allowedSyntaxHighlighterLanguagesNew.put("Ada", "ada");
        allowedSyntaxHighlighterLanguagesNew.put("ARM Assembly", "armasm");
        allowedSyntaxHighlighterLanguagesNew.put("AVR Assembler", "avrasm");
        allowedSyntaxHighlighterLanguagesNew.put("ActionScript", "actionscript");
        allowedSyntaxHighlighterLanguagesNew.put("Apache", "apache");
        allowedSyntaxHighlighterLanguagesNew.put("AppleScript", "applescript");
        allowedSyntaxHighlighterLanguagesNew.put("AsciiDoc", "asciidoc");
        allowedSyntaxHighlighterLanguagesNew.put("AspectJ", "aspectj");
        allowedSyntaxHighlighterLanguagesNew.put("AutoHotkey", "autohotkey");
        allowedSyntaxHighlighterLanguagesNew.put("AutoIt", "autoit");
        allowedSyntaxHighlighterLanguagesNew.put("Awk", "awk");
        allowedSyntaxHighlighterLanguagesNew.put("Axapta", "axapta");
        allowedSyntaxHighlighterLanguagesNew.put("Bash", "bash");
        allowedSyntaxHighlighterLanguagesNew.put("Basic", "basic");
        allowedSyntaxHighlighterLanguagesNew.put("BNF", "bnf");
        allowedSyntaxHighlighterLanguagesNew.put("Brainfuck", "brainf*ck");
        allowedSyntaxHighlighterLanguagesNew.put("Brainf*ck", "brainf*ck");
        allowedSyntaxHighlighterLanguagesNew.put("C#", "cs");
        allowedSyntaxHighlighterLanguagesNew.put("C++", "cpp");
        allowedSyntaxHighlighterLanguagesNew.put("C/AL", "cal");
        allowedSyntaxHighlighterLanguagesNew.put("Cache Object Script", "cos");
        allowedSyntaxHighlighterLanguagesNew.put("CMake", "cmake");
        allowedSyntaxHighlighterLanguagesNew.put("Coq", "coq");
        allowedSyntaxHighlighterLanguagesNew.put("CSP", "csp");
        allowedSyntaxHighlighterLanguagesNew.put("CSS", "css");
        allowedSyntaxHighlighterLanguagesNew.put("Cap\u2019n Proto", "capnproto");
        allowedSyntaxHighlighterLanguagesNew.put("Ceylon", "ceylon");
        allowedSyntaxHighlighterLanguagesNew.put("Clojure", "clojure");
        allowedSyntaxHighlighterLanguagesNew.put("Clojure REPL", "clojure-repl");
        allowedSyntaxHighlighterLanguagesNew.put("CoffeeScript", "coffeescript");
        allowedSyntaxHighlighterLanguagesNew.put("Crmsh", "crmsh");
        allowedSyntaxHighlighterLanguagesNew.put("Crystal", "crystal");
        allowedSyntaxHighlighterLanguagesNew.put("D", "d");
        allowedSyntaxHighlighterLanguagesNew.put("DNS Zone file", "dns");
        allowedSyntaxHighlighterLanguagesNew.put("DOS .bat", "dos");
        allowedSyntaxHighlighterLanguagesNew.put("Dart", "dart");
        allowedSyntaxHighlighterLanguagesNew.put("Delphi", "delphi");
        allowedSyntaxHighlighterLanguagesNew.put("Diff", "diff");
        allowedSyntaxHighlighterLanguagesNew.put("Django", "django");
        allowedSyntaxHighlighterLanguagesNew.put("Dockerfile", "dockerfile");
        allowedSyntaxHighlighterLanguagesNew.put("dsconfig", "dsconfig");
        allowedSyntaxHighlighterLanguagesNew.put("DTS (Device Tree)", "dts");
        allowedSyntaxHighlighterLanguagesNew.put("Dust", "dust");
        allowedSyntaxHighlighterLanguagesNew.put("EBNF", "ebnf");
        allowedSyntaxHighlighterLanguagesNew.put("Elixir", "elixir");
        allowedSyntaxHighlighterLanguagesNew.put("Elm", "elm");
        allowedSyntaxHighlighterLanguagesNew.put("ERB (Embedded Ruby)", "erb");
        allowedSyntaxHighlighterLanguagesNew.put("Erlang", "erlang");
        allowedSyntaxHighlighterLanguagesNew.put("Erlang REPL", "erlang-repl");
        allowedSyntaxHighlighterLanguagesNew.put("Excel", "excel");
        allowedSyntaxHighlighterLanguagesNew.put("F#", "fsharp");
        allowedSyntaxHighlighterLanguagesNew.put("FIX", "fix");
        allowedSyntaxHighlighterLanguagesNew.put("Fortran", "fortran");
        allowedSyntaxHighlighterLanguagesNew.put("G-code (ISO 6983)", "gcode");
        allowedSyntaxHighlighterLanguagesNew.put("Gams", "gams");
        allowedSyntaxHighlighterLanguagesNew.put("GAUSS", "gauss");
        allowedSyntaxHighlighterLanguagesNew.put("Gherkin", "gherkin");
        allowedSyntaxHighlighterLanguagesNew.put("Go", "go");
        allowedSyntaxHighlighterLanguagesNew.put("Golo", "golo");
        allowedSyntaxHighlighterLanguagesNew.put("GLSL", "glsl");
        allowedSyntaxHighlighterLanguagesNew.put("Gradle", "gradle");
        allowedSyntaxHighlighterLanguagesNew.put("Groovy", "groovy");
        allowedSyntaxHighlighterLanguagesNew.put("HTML, XML", "html");
        allowedSyntaxHighlighterLanguagesNew.put("HTTP", "http");
        allowedSyntaxHighlighterLanguagesNew.put("Haml", "haml");
        allowedSyntaxHighlighterLanguagesNew.put("Handlebars", "handlebars");
        allowedSyntaxHighlighterLanguagesNew.put("Haskell", "haskell");
        allowedSyntaxHighlighterLanguagesNew.put("Haxe", "haxe");
        allowedSyntaxHighlighterLanguagesNew.put("Hy", "hy");
        allowedSyntaxHighlighterLanguagesNew.put("Ini", "ini");
        allowedSyntaxHighlighterLanguagesNew.put("Inform 7", "inform7");
        allowedSyntaxHighlighterLanguagesNew.put("Intel x86 Assembly", "x86asm");
        allowedSyntaxHighlighterLanguagesNew.put("IRPF90", "irpf90");
        allowedSyntaxHighlighterLanguagesNew.put("Java", "java");
        allowedSyntaxHighlighterLanguagesNew.put("JavaScript", "javascript");
        allowedSyntaxHighlighterLanguagesNew.put("JSON", "json");
        allowedSyntaxHighlighterLanguagesNew.put("Julia", "julia");
        allowedSyntaxHighlighterLanguagesNew.put("Kotlin", "kotlin");
        allowedSyntaxHighlighterLanguagesNew.put("Lasso", "lasso");
        allowedSyntaxHighlighterLanguagesNew.put("LDIF", "ldif");
        allowedSyntaxHighlighterLanguagesNew.put("Leaf", "leaf");
        allowedSyntaxHighlighterLanguagesNew.put("Less", "less");
        allowedSyntaxHighlighterLanguagesNew.put("Lisp", "lisp");
        allowedSyntaxHighlighterLanguagesNew.put("LiveCode", "livecodeserver");
        allowedSyntaxHighlighterLanguagesNew.put("LiveScript", "livescript");
        allowedSyntaxHighlighterLanguagesNew.put("Lua", "lua");
        allowedSyntaxHighlighterLanguagesNew.put("Makefile", "makefile");
        allowedSyntaxHighlighterLanguagesNew.put("Markdown", "markdown");
        allowedSyntaxHighlighterLanguagesNew.put("Mathematica", "mathematica");
        allowedSyntaxHighlighterLanguagesNew.put("Matlab", "matlab");
        allowedSyntaxHighlighterLanguagesNew.put("Maxima", "maxima");
        allowedSyntaxHighlighterLanguagesNew.put("MEL", "mel");
        allowedSyntaxHighlighterLanguagesNew.put("Mercury", "mercury");
        allowedSyntaxHighlighterLanguagesNew.put("Mizar", "mizar");
        allowedSyntaxHighlighterLanguagesNew.put("Mojolicious", "mojolicious");
        allowedSyntaxHighlighterLanguagesNew.put("Monkey", "monkey");
        allowedSyntaxHighlighterLanguagesNew.put("Moonscript", "moonscript");
        allowedSyntaxHighlighterLanguagesNew.put("N1QL", "n1ql");
        allowedSyntaxHighlighterLanguagesNew.put("NSIS", "nsis");
        allowedSyntaxHighlighterLanguagesNew.put("Nginx", "nginx");
        allowedSyntaxHighlighterLanguagesNew.put("Nimrod", "nimrod");
        allowedSyntaxHighlighterLanguagesNew.put("Nix", "nix");
        allowedSyntaxHighlighterLanguagesNew.put("Objective C", "objectivec");
        allowedSyntaxHighlighterLanguagesNew.put("OCaml", "ocaml");
        allowedSyntaxHighlighterLanguagesNew.put("OpenGL Shading Language", "glsl");
        allowedSyntaxHighlighterLanguagesNew.put("OpenSCAD", "openscad");
        allowedSyntaxHighlighterLanguagesNew.put("Oracle Rules Language", "ruleslanguage");
        allowedSyntaxHighlighterLanguagesNew.put("Oxygene", "oxygene");
        allowedSyntaxHighlighterLanguagesNew.put("Parser3", "parser3");
        allowedSyntaxHighlighterLanguagesNew.put("Perl", "perl");
        allowedSyntaxHighlighterLanguagesNew.put("pf", "pf");
        allowedSyntaxHighlighterLanguagesNew.put("PHP", "php");
        allowedSyntaxHighlighterLanguagesNew.put("Pony", "pony");
        allowedSyntaxHighlighterLanguagesNew.put("PowerShell", "powershell");
        allowedSyntaxHighlighterLanguagesNew.put("Processing", "processing");
        allowedSyntaxHighlighterLanguagesNew.put("Prolog", "prolog");
        allowedSyntaxHighlighterLanguagesNew.put("Protocol Buffers", "protobuf");
        allowedSyntaxHighlighterLanguagesNew.put("Puppet", "puppet");
        allowedSyntaxHighlighterLanguagesNew.put("Python", "python");
        allowedSyntaxHighlighterLanguagesNew.put("Python profile", "profile");
        allowedSyntaxHighlighterLanguagesNew.put("Q", "k");
        allowedSyntaxHighlighterLanguagesNew.put("QML", "qml");
        allowedSyntaxHighlighterLanguagesNew.put("R", "r");
        allowedSyntaxHighlighterLanguagesNew.put("RenderMan RIB", "rib");
        allowedSyntaxHighlighterLanguagesNew.put("RenderMan RSL", "rsl");
        allowedSyntaxHighlighterLanguagesNew.put("Roboconf", "graph");
        allowedSyntaxHighlighterLanguagesNew.put("Ruby", "ruby");
        allowedSyntaxHighlighterLanguagesNew.put("Rust", "rust");
        allowedSyntaxHighlighterLanguagesNew.put("Scala", "scala");
        allowedSyntaxHighlighterLanguagesNew.put("Scheme", "scheme");
        allowedSyntaxHighlighterLanguagesNew.put("Scilab", "scilab");
        allowedSyntaxHighlighterLanguagesNew.put("SCSS", "scss");
        allowedSyntaxHighlighterLanguagesNew.put("Shell", "shell");
        allowedSyntaxHighlighterLanguagesNew.put("Smali", "smali");
        allowedSyntaxHighlighterLanguagesNew.put("Smalltalk", "smalltalk");
        allowedSyntaxHighlighterLanguagesNew.put("SML", "sml");
        allowedSyntaxHighlighterLanguagesNew.put("SQL", "sql");
        allowedSyntaxHighlighterLanguagesNew.put("Stan", "stan");
        allowedSyntaxHighlighterLanguagesNew.put("Stata", "stata");
        allowedSyntaxHighlighterLanguagesNew.put("STEP Part 21 (ISO 10303-21)", "p21");
        allowedSyntaxHighlighterLanguagesNew.put("Stylus", "stylus");
        allowedSyntaxHighlighterLanguagesNew.put("SubUnit", "subunit");
        allowedSyntaxHighlighterLanguagesNew.put("Swift", "swift");
        allowedSyntaxHighlighterLanguagesNew.put("Tcl", "tcl");
        allowedSyntaxHighlighterLanguagesNew.put("Test Anything Protocol", "tap");
        allowedSyntaxHighlighterLanguagesNew.put("TeX", "tex");
        allowedSyntaxHighlighterLanguagesNew.put("Thrift", "thrift");
        allowedSyntaxHighlighterLanguagesNew.put("TP", "tp");
        allowedSyntaxHighlighterLanguagesNew.put("Twig", "twig");
        allowedSyntaxHighlighterLanguagesNew.put("TypeScript", "typescript");
        allowedSyntaxHighlighterLanguagesNew.put("Vala", "vala");
        allowedSyntaxHighlighterLanguagesNew.put("VB.NET", "vbnet");
        allowedSyntaxHighlighterLanguagesNew.put("VBScript", "vbscript");
        allowedSyntaxHighlighterLanguagesNew.put("VBScript in HTML", "vbscript-html");
        allowedSyntaxHighlighterLanguagesNew.put("Verilog", "verilog");
        allowedSyntaxHighlighterLanguagesNew.put("VHDL", "vhdl");
        allowedSyntaxHighlighterLanguagesNew.put("Vim Script", "vim");
        allowedSyntaxHighlighterLanguagesNew.put("XL", "xl");
        allowedSyntaxHighlighterLanguagesNew.put("XML", "xml");
        allowedSyntaxHighlighterLanguagesNew.put("XQuery", "xpath");
        allowedSyntaxHighlighterLanguagesNew.put("Zephir", "zephir");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility = new HashMap<String, String>();
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("bsh", "bash");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("c", "cpp");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("cc", "cpp");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("cpp", "cpp");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("cs", "cs");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("csh", "bash");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("cyc", "");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("cv", "");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("htm", "xml");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("html", "xml");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("java", "java");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("js", "javascript");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("m", "");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("mxml", "");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("perl", "perl");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("pl", "perl");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("pm", "perl");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("py", "python");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("rb", "ruby");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("sh", "bash");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("xhtml", "xml");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("xml", "xml");
        allowedSyntaxHighlighterLanguagesBackwardCompatibility.put("xsl", "xml");
    }
}

