/*
 * Decompiled with CFR 0.152.
 */
package io.codeclou.advanced.codeblock.macro.macro;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.sal.api.message.I18nResolver;
import io.codeclou.advanced.codeblock.macro.api.OnlineHelpLinkHelper;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeBlockCache;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeblockCacheKey;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeblockCacheService;
import io.codeclou.advanced.codeblock.macro.cache.AdvancedCodeblockMacroPreviewCacheService;
import io.codeclou.advanced.codeblock.macro.exceptions.AdvancedBaseException;
import io.codeclou.advanced.codeblock.macro.macro.base.BaseAdvancedCodeblockMacro;
import io.codeclou.advanced.codeblock.macro.macro.base.ContextContentIdAndMacroId;
import io.codeclou.advanced.codeblock.macro.macro.fetcher.FetchingMacroDefinitionHandler;
import io.codeclou.advanced.codeblock.macro.macro.render.MacroRenderType;
import io.codeclou.advanced.codeblock.macro.macro.transformer.MacroContextTransformHelper;
import io.codeclou.advanced.codeblock.macro.parser.AdvancedCodeBlocksMacroBodyParser;
import io.codeclou.advanced.codeblock.macro.parser.model.CodeBlockSection;
import io.codeclou.advanced.codeblock.macro.parser.model.ConfigAndContentUnparsed;
import io.codeclou.advanced.codeblock.macro.services.LoggedInConfluenceUserService;
import io.codeclou.advanced.codeblock.macro.services.PluginLicenseService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdvancedRemoteCodeBlockMacro
extends BaseAdvancedCodeblockMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(AdvancedRemoteCodeBlockMacro.class);

    @Autowired
    public AdvancedRemoteCodeBlockMacro(OnlineHelpLinkHelper onlineHelpLinkHelper, I18nResolver i18n, BootstrapManager bootstrapManager, AccessModeService accessModeService, PluginLicenseService pluginLicenseService, AdvancedCodeblockCacheService advancedCodeblockCacheService, AdvancedCodeblockMacroPreviewCacheService advancedCodeblockMacroPreviewCacheService, LoggedInConfluenceUserService loggedInConfluenceUserService, FetchingMacroDefinitionHandler fetchingMacroDefinitionHandler, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, SettingsManager settingsManager) {
        this.onlineHelpLinkHelper = onlineHelpLinkHelper;
        this.i18n = i18n;
        this.bootstrapManager = bootstrapManager;
        this.accessModeService = accessModeService;
        this.pluginLicenseService = pluginLicenseService;
        this.advancedCodeblockCacheService = advancedCodeblockCacheService;
        this.advancedCodeblockMacroPreviewCacheService = advancedCodeblockMacroPreviewCacheService;
        this.loggedInConfluenceUserService = loggedInConfluenceUserService;
        this.fetchingMacroDefinitionHandler = fetchingMacroDefinitionHandler;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.settingsManager = settingsManager;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        String renderTypeForFrontend = MacroRenderType.determineRenderType(conversionContext);
        try {
            ContextContentIdAndMacroId contextAndIds = this.getContextWithParamsForAllMacros("ACR", renderTypeForFrontend, params, body, conversionContext);
            if ("EXPORT_NO_JS_PLAIN_TEXT".equalsIgnoreCase(renderTypeForFrontend)) {
                String remoteFileUrl = this.getStringOrDefaultFromParams(params, "remotefileurl", null);
                String remoteFileHttpUser = this.getStringOrDefaultFromParams(params, "remotefilehttpuser", null);
                String remoteFileHttpPassword = this.getStringOrDefaultFromParams(params, "remotefilehttppassword", null);
                AdvancedCodeblockCacheKey cacheKey = new AdvancedCodeblockCacheKey(contextAndIds.getContentId(), contextAndIds.getMacroId());
                AdvancedCodeBlockCache cacheObj = this.advancedCodeblockCacheService.getFromCacheOrDownload(cacheKey, remoteFileUrl, remoteFileHttpUser, remoteFileHttpPassword);
                ConfigAndContentUnparsed configAndContentUnparsed = new ConfigAndContentUnparsed(body, cacheObj.getRemoteFileContent());
                List<CodeBlockSection> codeblocks = AdvancedCodeBlocksMacroBodyParser.parseConfigWithContent(configAndContentUnparsed);
                contextAndIds.getContext().put("codeblocks", codeblocks);
            }
            return this.renderTemplate("templates/advanced-codeblocks-success.vm", contextAndIds.getContext());
        }
        catch (AdvancedBaseException e) {
            return this.renderErrorWithTemplate(e.getRestExceptionKey(), e.getMessage(), "ACR");
        }
        catch (Exception e) {
            log.error("Unexpected Exception: ", (Throwable)e);
            throw new MacroExecutionException((Throwable)e);
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.PLAIN_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    @Override
    public String execute(Map params, String body, RenderContext renderContext) throws MacroException {
        try {
            return this.execute((Map<String, String>)params, body, MacroContextTransformHelper.transform(renderContext));
        }
        catch (Exception e) {
            throw new MacroException((Throwable)e);
        }
    }

    @Override
    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    @Override
    public boolean hasBody() {
        return true;
    }
}

