/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.services;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.moveworkforward.confluence.microsoftteams.notifier.services.UserService;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class DefaultUserService
implements UserService {
    private final UserAccessor userAccessor;
    private final LocaleManager localeManager;

    @Inject
    public DefaultUserService(@ComponentImport UserAccessor userAccessor, @ComponentImport LocaleManager localeManager) {
        this.userAccessor = userAccessor;
        this.localeManager = localeManager;
    }

    @Override
    public Locale getLocale(User user) {
        return this.localeManager.getLocale(user);
    }

    @Override
    public Collection<ConfluenceUser> getUsersByKeysAndGroups(List<String> userKeys, List<String> groupNames) {
        return this.getUserMapByKeysAndGroupNames(userKeys, groupNames).values();
    }

    protected Map<String, ConfluenceUser> getUsersByGroupNames(List<String> groupNames) {
        HashMap<String, ConfluenceUser> ret = new HashMap<String, ConfluenceUser>();
        for (String groupName : groupNames) {
            Group group = this.userAccessor.getGroup(groupName);
            if (group == null) continue;
            for (ConfluenceUser user : this.userAccessor.getMembers(group)) {
                ret.put(user.getKey().getStringValue(), user);
            }
        }
        return ret;
    }

    private Map<String, ConfluenceUser> getUsersByKeys(List<String> userKeys) {
        HashMap<String, ConfluenceUser> ret = new HashMap<String, ConfluenceUser>();
        for (String userKey : userKeys) {
            ConfluenceUser user = this.getUserByKey(userKey);
            if (user == null) continue;
            ret.put(userKey, user);
        }
        return ret;
    }

    protected ConfluenceUser getUserByKey(String userKey) {
        return this.userAccessor.getUserByKey(new UserKey(userKey));
    }

    private Map<String, ConfluenceUser> getUserMapByKeysAndGroupNames(List<String> userKeys, List<String> groupNames) {
        Map<String, ConfluenceUser> usersMap = this.getUsersByKeys(userKeys);
        usersMap.putAll(this.getUsersByGroupNames(groupNames));
        return usersMap;
    }
}

