/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.rest;

import com.moveworkforward.confluence.microsoftteams.notifier.model.ConfluenceGlobalSettings;
import com.moveworkforward.confluence.microsoftteams.notifier.report.ScheduledReportManager;
import com.moveworkforward.confluence.microsoftteams.notifier.services.GlobalSettingsService;
import com.moveworkforward.license.LicenseInfoProvider;
import com.moveworkforward.rest.AbstractGlobalSettingsController;
import com.moveworkforward.util.MwfPropertyUtils;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Map;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component(value="GlobalSettingsController")
@Path(value="/global-settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class GlobalSettingsController
extends AbstractGlobalSettingsController<ConfluenceGlobalSettings> {
    private final ScheduledReportManager scheduledReportManager;
    private final boolean isDevMode;

    @Inject
    public GlobalSettingsController(GlobalSettingsService globalSettingsService, ScheduledReportManager scheduledReportManager, LicenseInfoProvider licenseInfoProvider, Environment environment) {
        super((com.moveworkforward.service.GlobalSettingsService)globalSettingsService, licenseInfoProvider);
        this.scheduledReportManager = scheduledReportManager;
        this.isDevMode = MwfPropertyUtils.getInstance().isDevMode(environment);
    }

    @GET
    @Path(value="/reports/disable")
    public Map<String, String> disableReportsRunner() {
        if (this.isDevMode) {
            this.scheduledReportManager.unscheduleJob();
            this.scheduledReportManager.unregisterJobRunner();
            return Map.of("scheduler", "disabled");
        }
        throw new RuntimeException("Method is not allowed");
    }

    @GET
    @Path(value="/reports/enable")
    public Map<String, String> enableReportsRunner() {
        if (this.isDevMode) {
            this.scheduledReportManager.startIfNeeded();
            return Map.of("scheduler", "enabled");
        }
        throw new RuntimeException("Method is not allowed");
    }

    @GET
    public ConfluenceGlobalSettings get() {
        ConfluenceGlobalSettings globalSettings = (ConfluenceGlobalSettings)super.get();
        ((GlobalSettingsService)this.globalSettingsService).enrich(globalSettings);
        return globalSettings;
    }
}

