/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.ao.PluginRepository;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.component.SendPayloadTask;
import com.moveworkforward.confluence.microsoftteams.notifier.actions.Source;
import com.moveworkforward.confluence.microsoftteams.notifier.components.ComponentProvider;
import com.moveworkforward.confluence.microsoftteams.notifier.model.Configuration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ConfigurationRule;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ConfluenceGlobalSettings;
import com.moveworkforward.confluence.microsoftteams.notifier.model.DecoratorSpace;
import com.moveworkforward.confluence.microsoftteams.notifier.model.QuestionType;
import com.moveworkforward.confluence.microsoftteams.notifier.model.TestWebhookUrlRequest;
import com.moveworkforward.confluence.microsoftteams.notifier.model.TestWebhookUrlResponse;
import com.moveworkforward.confluence.microsoftteams.notifier.model.UrlConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.services.ConfigurationServiceImpl;
import com.moveworkforward.confluence.microsoftteams.notifier.services.GlobalSettingsService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.UrlConfigurationServiceImpl;
import com.moveworkforward.confluence.microsoftteams.notifier.util.SpaceUtils;
import com.moveworkforward.model.AbstractGlobalSettings;
import com.moveworkforward.model.UrlManagement;
import com.moveworkforward.model.teams.MessageData;
import com.moveworkforward.model.teams.payload.Message;
import com.moveworkforward.util.ConnectorUtil;
import com.moveworkforward.util.TeamsPayloadUtils;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="configuration")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public final class ConfigurationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationController.class);
    private static final boolean CHECK_PERMISSIONS = true;
    private final ConfigurationServiceImpl configurationService;
    private final SpaceManager spaceManager;
    private final PermissionManager permissionManager;
    private final PluginAccessor pluginAccessor;
    private final UrlConfigurationServiceImpl urlConfigurationService;
    private final GlobalSettingsService globalSettingsService;
    private final List<PluginRepository<? extends PluginEntity>> repositories;

    @Inject
    public ConfigurationController(ConfigurationServiceImpl configurationService, UrlConfigurationServiceImpl urlConfigurationService, GlobalSettingsService globalSettingsService, ComponentProvider componentProvider, @ComponentImport SpaceManager spaceManager, @ComponentImport PermissionManager permissionManager, @ComponentImport PluginAccessor pluginAccessor) {
        this.configurationService = configurationService;
        this.urlConfigurationService = urlConfigurationService;
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
        this.pluginAccessor = pluginAccessor;
        this.globalSettingsService = globalSettingsService;
        this.repositories = componentProvider.getRepositories();
    }

    @GET
    @Path(value="/spaces")
    public List<DecoratorSpace> getSpaces(@QueryParam(value="currentSpaceKey") String currentSpaceKey) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        ArrayList<DecoratorSpace> spaces = new ArrayList<DecoratorSpace>();
        if (currentSpaceKey == null) {
            TreeMap<String, DecoratorSpace> result = new TreeMap<String, DecoratorSpace>();
            SpaceUtils spaceUtils = new SpaceUtils(this.spaceManager, this.repositories);
            spaceUtils.fillUpSpaces(result);
            ConfluenceGlobalSettings globalSettings = (ConfluenceGlobalSettings)this.globalSettingsService.get(false);
            spaceUtils.fillUpSpaces(globalSettings.getAllowedKeys(), result);
            spaceUtils.fillUpSpaces(globalSettings.getIgnoredKeys(), result);
            spaceUtils.fillUpSpaces(globalSettings.getSpacesWhereAllowedNotificationsForViewRestrictedContent(), result);
            spaces.addAll(result.values());
        } else {
            Space space = this.spaceManager.getSpace(currentSpaceKey);
            if (this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, (Object)space)) {
                spaces.add(new DecoratorSpace(space));
            }
        }
        return spaces;
    }

    @GET
    @Path(value="/event-types")
    public Set<Map<String, String>> getSupportedEventTypes() {
        ArrayList<Source> supportedEventTypes = new ArrayList<Source>();
        supportedEventTypes.add(Source.PAGE_CREATED);
        supportedEventTypes.add(Source.PAGE_UPDATED);
        supportedEventTypes.add(Source.PAGE_DELETED);
        supportedEventTypes.add(Source.COMMENT_CREATED);
        supportedEventTypes.add(Source.COMMENT_UPDATED);
        supportedEventTypes.add(Source.BLOGPOST_CREATED);
        supportedEventTypes.add(Source.BLOGPOST_UPDATED);
        supportedEventTypes.add(Source.BLOGPOST_DELETED);
        supportedEventTypes.add(Source.ATTACHMENT_CREATED);
        supportedEventTypes.add(Source.ATTACHMENT_UPDATED);
        try {
            if (this.pluginAccessor.isPluginEnabled("com.atlassian.confluence.extra.team-calendars")) {
                supportedEventTypes.add(Source.CALENDAR_EVENT_CREATED);
                supportedEventTypes.add(Source.CALENDAR_EVENT_UPDATED);
                supportedEventTypes.add(Source.CALENDAR_EVENT_DELETED);
            }
        }
        catch (Throwable e) {
            log.debug("Could not test Team Calendars plugin", e);
        }
        if (this.pluginAccessor.isPluginEnabled("com.elitesoftsp.confluence.tiny.question.answer.plugins")) {
            supportedEventTypes.add(Source.ANSWER_CREATED);
            supportedEventTypes.add(Source.QUESTION_CREATED);
        } else {
            try {
                if (this.pluginAccessor.isPluginModuleEnabled(QuestionType.ANSWER.getPluginModuleKey())) {
                    supportedEventTypes.add(Source.ANSWER_CREATED);
                }
            }
            catch (Throwable e) {
                log.debug("Could not test Answers plugin", e);
            }
            try {
                if (this.pluginAccessor.isPluginModuleEnabled(QuestionType.QUESTION.getPluginModuleKey())) {
                    supportedEventTypes.add(Source.QUESTION_CREATED);
                }
            }
            catch (Throwable e) {
                log.debug("Could not test Questions plugin", e);
            }
        }
        LinkedHashSet<Map<String, String>> result = new LinkedHashSet<Map<String, String>>();
        supportedEventTypes.forEach(eventType -> result.add(Map.of("type", eventType.toString(), "text", eventType.getName())));
        return result;
    }

    @POST
    @Path(value="/test-webhook-url")
    public TestWebhookUrlResponse testWebhookUrl(TestWebhookUrlRequest request) {
        UrlConfiguration urlConfiguration;
        log.debug("testWebhookUrl: " + request.toString());
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser == null) {
            throw new RuntimeException("User is not authenticated.");
        }
        String webhookUrl = request.getWebhookUrl();
        if (request.isUseManagedWebhookUrl() && request.getWebhookUrlId() != null && (urlConfiguration = (UrlConfiguration)this.urlConfigurationService.get(request.getWebhookUrlId(), true)) != null) {
            webhookUrl = urlConfiguration.getUrl();
        }
        log.debug("Using webhookUrl[{}] to send the test message", (Object)webhookUrl);
        AbstractGlobalSettings GlobalSettings = this.globalSettingsService.get(false);
        UrlManagement urlManagement = Optional.ofNullable(GlobalSettings.getUrlManagement()).orElse(new UrlManagement());
        urlManagement.validateUrl(webhookUrl);
        TestWebhookUrlResponse response = new TestWebhookUrlResponse();
        response.setWebhookUrl(request.getWebhookUrl());
        response.setUseManagedWebhookUrl(request.isUseManagedWebhookUrl());
        response.setWebhookUrlId(request.getWebhookUrlId());
        try {
            MessageData messageData = new MessageData("Test message", "Title of the test message", "Created by Microsoft Teams Confluence Connector");
            Message message = TeamsPayloadUtils.createToggleableItemsMessage((MessageData)messageData);
            SendPayloadTask task = new SendPayloadTask(ConnectorUtil.createObjectMapper((boolean)true).writeValueAsString((Object)message), webhookUrl);
            task.sendMessage(true);
            response.setSuccess(true);
        }
        catch (IOException | URISyntaxException e) {
            response.setSuccess(false);
            response.setErrorMessage(e.getMessage());
        }
        return response;
    }

    @GET
    public List<ConfigurationRule> getConfigurations(@QueryParam(value="spaceKey") String spaceKey) {
        log.debug("getConfigurations for spaceKey: " + spaceKey);
        List configurations = StringUtils.isBlank((CharSequence)spaceKey) ? this.configurationService.getAll(true) : this.configurationService.getByTag(spaceKey, true);
        List<ConfigurationRule> result = configurations.stream().map(ConfigurationRule::new).collect(Collectors.toList());
        return result;
    }

    @POST
    public ConfigurationRule saveConfiguration(Configuration configuration) {
        log.debug("Saving: " + configuration.toString());
        Configuration dto = (Configuration)this.configurationService.save(configuration, true);
        return new ConfigurationRule(dto);
    }

    @Path(value="key/{key}")
    @DELETE
    public void deleteConfigurationByKey(@PathParam(value="key") String key) {
        if (key == null) {
            throw new RuntimeException("Id was not supplied.");
        }
        this.configurationService.deleteByKey(key);
    }

    @Path(value="/{id}")
    @DELETE
    public void deleteConfigurationByKey(@PathParam(value="id") Integer id) {
        if (id == null) {
            throw new RuntimeException("Id was not supplied.");
        }
        this.configurationService.delete(id, true);
    }
}

