/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ConfigurationLevel;
import com.moveworkforward.confluence.microsoftteams.notifier.report.AbstractReportExecutor;
import com.moveworkforward.confluence.microsoftteams.notifier.report.ReportConfigurationTester;
import com.moveworkforward.confluence.microsoftteams.notifier.services.AbstractReportConfigurationService;
import com.moveworkforward.model.ScheduledPluginEntity;
import com.moveworkforward.report.PayloadDataHolder;
import com.moveworkforward.service.ReportService;
import com.moveworkforward.util.ConnectorUtil;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public abstract class AbstractScheduledReportsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractScheduledReportsController.class);
    protected static final boolean CHECK_PERMISSIONS = true;
    protected final Map<String, AbstractReportExecutor<? extends ScheduledPluginEntity, ? extends PayloadDataHolder>> reportExecutors;
    private final Map<String, ReportService<? extends ScheduledPluginEntity>> reportServices;
    protected ObjectMapper objectMapper = ConnectorUtil.createObjectMapper();
    protected ReportConfigurationTester reportConfigurationTester = new ReportConfigurationTester();
    private boolean isDevMode;

    @Inject
    public AbstractScheduledReportsController(List<ReportService<? extends ScheduledPluginEntity>> reportServices, List<AbstractReportExecutor<? extends ScheduledPluginEntity, ? extends PayloadDataHolder>> reportExecutors, Environment environment) {
        this.reportServices = reportServices.stream().filter(service -> this.acceptType(service.getType())).collect(Collectors.toMap(ReportService::getType, reportService -> reportService));
        this.reportExecutors = reportExecutors.stream().filter(executor -> this.acceptType(executor.getType())).collect(Collectors.toMap(AbstractReportExecutor::getType, executor -> executor));
        this.isDevMode = (Boolean)environment.getProperty("moveworkforward.dev.mode", Boolean.class, (Object)false);
    }

    protected abstract boolean acceptType(String var1);

    @GET
    public List<? extends ScheduledPluginEntity> getConfigurations(@QueryParam(value="spaceKey") String spaceKey) {
        List configurations;
        log.debug("Reminder Configurations for level: " + spaceKey);
        if (spaceKey == null || ConfigurationLevel.GLOBAL.toString().equals(spaceKey)) {
            configurations = this.reportServices.values().stream().flatMap(s -> s.getAll(true).stream()).collect(Collectors.toList());
        } else if (ConfigurationLevel.PERSONAL.toString().equals(spaceKey)) {
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            configurations = this.reportServices.values().stream().flatMap(s -> s.getByTag(confluenceUser.getKey().getStringValue(), true).stream()).collect(Collectors.toList());
        } else {
            configurations = this.reportServices.values().stream().flatMap(s -> s.getByTag(spaceKey, true).stream()).collect(Collectors.toList());
        }
        return configurations;
    }

    @Path(value="/{type}")
    @GET
    public List<? extends ScheduledPluginEntity> getConfigurationsByType(@PathParam(value="type") String type, @QueryParam(value="tag") String tag) {
        List configurations;
        log.debug("Reminder Configurations by type {}: " + type);
        ReportService reportService = this.getService(type);
        if (tag == null || ConfigurationLevel.GLOBAL.toString().equals(tag)) {
            configurations = reportService.getAll(true);
        } else if (ConfigurationLevel.PERSONAL.toString().equals(tag)) {
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            configurations = reportService.getByTag(confluenceUser.getKey().getStringValue(), true);
        } else {
            configurations = reportService.getByTag(tag, true);
        }
        return configurations;
    }

    @Path(value="/{type}")
    @POST
    public ScheduledPluginEntity saveConfiguration(@PathParam(value="type") String type, Map<String, Object> configuration) {
        log.debug("Saving: type {}, configuration {}", (Object)type, configuration);
        ReportService reportService = this.getService(type);
        ScheduledPluginEntity toSave = (ScheduledPluginEntity)this.objectMapper.convertValue(configuration, reportService.getConfigurationClass());
        ScheduledPluginEntity result = (ScheduledPluginEntity)reportService.save((PluginEntity)toSave, true);
        return result;
    }

    @Path(value="/{type}/{id}")
    @DELETE
    public ScheduledPluginEntity deleteConfigurationById(@PathParam(value="type") String type, @PathParam(value="id") Integer id) {
        if (id == null) {
            throw new RuntimeException("Id was not supplied.");
        }
        ReportService reportService = this.getService(type);
        return (ScheduledPluginEntity)reportService.delete(id.intValue(), true);
    }

    @Path(value="/{type}/{id}")
    @GET
    public ScheduledPluginEntity getConfigurationById(@PathParam(value="type") String type, @PathParam(value="id") Integer id) {
        if (id == null) {
            throw new RuntimeException("Id was not supplied.");
        }
        ReportService reportService = this.getService(type);
        return (ScheduledPluginEntity)reportService.get(id.intValue(), true);
    }

    @Path(value="/{type}/test-configuration")
    @POST
    public Map<String, Object> testReportConfiguration(@PathParam(value="type") String type, @QueryParam(value="date") String date, @QueryParam(value="send") Boolean send, Map<String, Object> configuration) {
        log.debug("Test: date {}, send {}, configuration {}", new Object[]{date, send, configuration});
        ReportService reportService = this.getService(type);
        ScheduledPluginEntity toCheck = (ScheduledPluginEntity)this.objectMapper.convertValue(configuration, reportService.getConfigurationClass());
        if (reportService instanceof AbstractReportConfigurationService) {
            ((AbstractReportConfigurationService)reportService).validate(toCheck);
        }
        return this.reportConfigurationTester.testConfiguration(date, send, toCheck, this.getExecutor(type));
    }

    @Path(value="/{type}/test-configurations")
    @GET
    public Map<String, Object> testAllReportConfigurations(@PathParam(value="type") String type, @QueryParam(value="date") String date, @QueryParam(value="send") Boolean send) {
        log.debug("Test: date {}, send {}", (Object)date, (Object)send);
        return this.reportConfigurationTester.testConfiguration(date, send, null, this.getExecutor(type));
    }

    @Path(value="/{type}/execute")
    @GET
    public Map<String, Object> executeReports(@PathParam(value="type") String type) {
        if (this.isDevMode) {
            log.debug("Execute reports: {}", (Object)type);
            this.getExecutor(type).executeReports();
            return Map.of("status", "ok");
        }
        throw new RuntimeException("Method is not allowed");
    }

    private AbstractReportExecutor getExecutor(String type) {
        AbstractReportExecutor<? extends ScheduledPluginEntity, ? extends PayloadDataHolder> executor = this.reportExecutors.get(type);
        if (executor == null) {
            throw new RuntimeException("Executor is not found for type: " + type);
        }
        return executor;
    }

    private <T extends ScheduledPluginEntity> ReportService<T> getService(String type) {
        ReportService<? extends ScheduledPluginEntity> service = this.reportServices.get(type);
        if (service == null) {
            throw new RuntimeException("Service is not found for type: " + type);
        }
        return service;
    }
}

