/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.report;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.tasklist.Task;
import com.atlassian.confluence.plugins.tasklist.TaskStatus;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.moveworkforward.confluence.microsoftteams.notifier.components.ConfluenceTaskBodyFormatter;
import com.moveworkforward.confluence.microsoftteams.notifier.model.InlineTaskDataHolder;
import com.moveworkforward.confluence.microsoftteams.notifier.model.TaskReminderReportConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.report.AbstractReportCreator;
import com.moveworkforward.model.teams.MessageData;
import com.moveworkforward.model.teams.payload.Message;
import com.moveworkforward.util.TeamsPayloadUtils;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InlineTaskReminderScheduledReportCreator
extends AbstractReportCreator<TaskReminderReportConfiguration, InlineTaskDataHolder> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InlineTaskReminderScheduledReportCreator.class);
    private final ConfluenceTaskBodyFormatter confluenceTaskBodyFormatter;

    @Inject
    public InlineTaskReminderScheduledReportCreator(@ComponentImport UserAccessor userAccessor, @ComponentImport PageManager pageManager, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport LocaleManager localeManager, @ComponentImport TimeZoneManager timeZoneManager, @ComponentImport I18nResolver i18nResolver) {
        super(i18nResolver, webResourceUrlProvider);
        this.confluenceTaskBodyFormatter = new ConfluenceTaskBodyFormatter(userAccessor, pageManager, webResourceUrlProvider, localeManager, timeZoneManager);
    }

    @Override
    public String createPayload(TaskReminderReportConfiguration configuration, InlineTaskDataHolder payloadHolder) {
        String payload = null;
        Set<Task> tasks = payloadHolder.getTasks();
        String configurationName = configuration.getName();
        if (CollectionUtils.isEmpty(tasks)) {
            log.debug("createTasksReminderCardFromTasks() no tasks");
            return null;
        }
        try {
            Object title = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.reports.task.reminder.title");
            title = (String)title + " - " + configurationName;
            String showText = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.show");
            String hideText = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.hide");
            MessageData messageData = new MessageData((String)title, "", null);
            Optional.ofNullable(this.getCompleteTasks(tasks, showText, hideText)).ifPresent(item -> messageData.getItems().add(item));
            Optional.ofNullable(this.getIncompleteTasks(tasks, showText, hideText)).ifPresent(item -> messageData.getItems().add(item));
            Message message = TeamsPayloadUtils.createToggleableItemsMessage((MessageData)messageData);
            payload = this.objectMapper.writeValueAsString((Object)message);
            log.debug("Progress statistics report payload: {}", (Object)payload);
        }
        catch (Exception e) {
            log.error("Can't create card from task", (Throwable)e);
        }
        return payload;
    }

    private MessageData.Item getIncompleteTasks(Set<Task> allTasks, String showText, String hideText) {
        List<Task> tasks = allTasks.stream().filter(t -> t.getStatus() == TaskStatus.UNCHECKED).collect(Collectors.toList());
        if (tasks.isEmpty()) {
            return null;
        }
        Object header = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.tasks.incomplete");
        header = (String)header + " (" + tasks.size() + ")";
        return new MessageData.Item("incompleteTasks", (String)header, showText, hideText, this.getFacts(tasks));
    }

    private MessageData.Item getCompleteTasks(Set<Task> allTasks, String showText, String hideText) {
        List<Task> tasks = allTasks.stream().filter(t -> t.getStatus() == TaskStatus.CHECKED).collect(Collectors.toList());
        if (tasks.isEmpty()) {
            return null;
        }
        Object header = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.tasks.complete");
        header = (String)header + " (" + tasks.size() + ")";
        return new MessageData.Item("completeTasks", (String)header, showText, hideText, this.getFacts(tasks));
    }

    private List getFacts(List<Task> tasks) {
        return tasks.stream().map(this.confluenceTaskBodyFormatter::parseTaskBody).collect(Collectors.toList());
    }
}

