/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Generated;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true, value={"period"})
public class TimePeriod {
    private static final int DAYS_IN_WEEK = 7;
    private int interval;
    private TimeUnit timeUnit = TimeUnit.DAY;

    public Period getPeriod() {
        if (this.timeUnit == null) {
            throw new IllegalArgumentException("Time unit is not set");
        }
        switch (this.timeUnit.ordinal()) {
            case 5: {
                return Period.minutes((int)this.interval);
            }
            case 4: {
                return Period.hours((int)this.interval);
            }
            case 3: {
                return Period.days((int)this.interval);
            }
            case 2: {
                return Period.days((int)(this.interval * 7));
            }
            case 1: {
                return Period.months((int)this.interval);
            }
            case 0: {
                return Period.years((int)this.interval);
            }
        }
        throw new IllegalArgumentException("Unknown time unit: " + String.valueOf((Object)this.timeUnit));
    }

    @Generated
    public int getInterval() {
        return this.interval;
    }

    @Generated
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Generated
    public void setInterval(int interval) {
        this.interval = interval;
    }

    @Generated
    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    @Generated
    public String toString() {
        return "TimePeriod(super=" + super.toString() + ", interval=" + this.interval + ", timeUnit=" + String.valueOf((Object)this.timeUnit) + ")";
    }

    @Generated
    public TimePeriod() {
    }

    @Generated
    public TimePeriod(int interval, TimeUnit timeUnit) {
        this.interval = interval;
        this.timeUnit = timeUnit;
    }

    public static enum TimeUnit {
        YEAR(DurationFieldType.years(), "com.moveworkforward.confluence.microsoft.teams.year"),
        MONTH(DurationFieldType.months(), "com.moveworkforward.confluence.microsoft.teams.month"),
        WEEK(DurationFieldType.weeks(), "com.moveworkforward.confluence.microsoft.teams.week"),
        DAY(DurationFieldType.days(), "com.moveworkforward.confluence.microsoft.teams.day"),
        HOUR(DurationFieldType.hours(), "com.moveworkforward.confluence.microsoft.teams.hour"),
        MINUTE(DurationFieldType.minutes(), "com.moveworkforward.confluence.microsoft.teams.minute");

        private final DurationFieldType durationFieldType;
        private final String localizationKey;

        private TimeUnit(DurationFieldType durationFieldType, String localizationKey) {
            this.durationFieldType = durationFieldType;
            this.localizationKey = localizationKey;
        }

        @Generated
        public DurationFieldType getDurationFieldType() {
            return this.durationFieldType;
        }

        @Generated
        public String getLocalizationKey() {
            return this.localizationKey;
        }
    }
}

