/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.configuration;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.moveworkforward.confluence.microsoftteams.notifier.configuration.Configuration;
import com.moveworkforward.util.ConnectorUtil;
import jakarta.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationManager.class);
    private static final String BANDANA_KEY = "com.moveworkforward.confluence.microsoftteams.notifier.configuration";
    private final BandanaManager bandanaManager;
    private final ObjectMapper objectMapper;

    @Inject
    public ConfigurationManager(@ComponentImport BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
        this.objectMapper = ConnectorUtil.createObjectMapper();
    }

    public Configuration readConfiguration() {
        return this.readBandanaValue(ConfluenceBandanaContext.GLOBAL_CONTEXT, Configuration.class, new Configuration());
    }

    private <T> T readBandanaValue(ConfluenceBandanaContext bandanaContext, Class<T> targetClass, T defaultValue) {
        Object fromBandana = this.bandanaManager.getValue((BandanaContext)bandanaContext, BANDANA_KEY);
        LOGGER.info("Read configuration {} with JSON {}.", (Object)bandanaContext.getContextKey(), fromBandana);
        try {
            return (T)this.objectMapper.readValue(fromBandana.toString(), targetClass);
        }
        catch (Exception e) {
            LOGGER.info("Using default configuration for {}.", targetClass);
            return defaultValue;
        }
    }
}

