/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.components;

import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginInstalledEvent;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ConfluenceGlobalSettings;
import com.moveworkforward.confluence.microsoftteams.notifier.repository.GlobalSettingsRepository;
import jakarta.inject.Inject;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={LifecycleAware.class})
public class LifecycleEventListener
implements LifecycleAware,
DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LifecycleEventListener.class);
    public static final String PLUGIN_KEY = "confluence-microsoft-teams-connector";
    private final PluginAccessor pluginAccessor;
    private final PluginLicenseManager pluginLicenseManager;
    private final PluginEventManager pluginEventManager;
    private final String baseUrl;
    private final GlobalSettingsRepository globalSettingRepository;

    @Inject
    public LifecycleEventListener(@ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginEventManager pluginEventManager, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, GlobalSettingsRepository globalSettingRepository) {
        this.pluginAccessor = pluginAccessor;
        this.pluginLicenseManager = pluginLicenseManager;
        this.baseUrl = webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE);
        this.globalSettingRepository = globalSettingRepository;
        this.pluginEventManager = pluginEventManager;
        this.pluginEventManager.register((Object)this);
    }

    public void onStart() {
    }

    public void onStop() {
        this.safeUnregisterListener();
    }

    public void destroy() {
        this.safeUnregisterListener();
    }

    @PluginEventListener
    public void onEnabled(PluginEnabledEvent event) {
        String appKey = event.getPlugin().getKey();
        if (appKey.equals(PLUGIN_KEY) && this.pluginAccessor.isPluginEnabled(PLUGIN_KEY)) {
            this.printPluginInformation();
            this.initGlobalSettings();
        }
    }

    private void initGlobalSettings() {
        try {
            ConfluenceGlobalSettings globalSettings = this.globalSettingRepository.getAll().stream().findFirst().orElse(null);
            if (globalSettings == null) {
                globalSettings = new ConfluenceGlobalSettings();
                this.globalSettingRepository.save((PluginEntity)globalSettings);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    @PluginEventListener
    public void onInstalled(PluginInstalledEvent event) {
        String appKey = event.getPlugin().getKey();
        if (appKey.equals(PLUGIN_KEY)) {
            this.printDependencies();
        }
    }

    @PluginEventListener
    public void onDisabled(PluginDisabledEvent event) {
        String appKey = event.getPlugin().getKey();
        if (appKey.equals(PLUGIN_KEY)) {
            log.info("+++++++++++++++++++++++++ Microsoft Teams Confluence Connector Disabled +++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        }
    }

    @PluginEventListener
    public void onUninstalled(PluginUninstalledEvent event) {
        String appKey = event.getPlugin().getKey();
        if (appKey.equals(PLUGIN_KEY)) {
            log.info("+++++++++++++++++++++++++ Microsoft Teams Confluence Connector Uninstalled +++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        }
    }

    private void printPluginInformation() {
        try {
            Option license = this.pluginLicenseManager.getLicense();
            if (license.isDefined()) {
                PluginLicense pluginLicense = (PluginLicense)license.get();
                Optional<Plugin> plugin = Optional.ofNullable(this.pluginAccessor.getPlugin(PLUGIN_KEY));
                plugin.ifPresent(thePlugin -> {
                    log.warn("\n\n++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
                    log.warn("Microsoft Teams Confluence Connector " + thePlugin.getPluginInformation().getVersion() + " is started, instance: " + pluginLicense.getServerId() + "\nLicense: " + (String)pluginLicense.getSupportEntitlementNumber().getOrElse((Object)"") + ", " + pluginLicense.getLicenseType().toString() + " expires: " + pluginLicense.getExpiryZonedDate().toString() + "\nLicensed to: " + pluginLicense.getOrganization().getName());
                    log.warn("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n\n");
                });
            } else {
                log.warn("\n\n++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
                log.warn("Microsoft Teams Confluence Connector has not license defined.");
                log.warn("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n\n");
            }
        }
        catch (RuntimeException e) {
            log.debug("Unexpected error initialising plugin state for Microsoft Teams Confluence Connector:", (Throwable)e);
        }
    }

    private void printDependencies() {
        log.warn("\n\n+++++++++++++++++++++++++ Microsoft Teams Confluence Connector dependencies +++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
        log.warn("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n\n");
    }

    private void safeUnregisterListener() {
        try {
            this.pluginEventManager.unregister((Object)this);
        }
        catch (RuntimeException e) {
            log.error("Failed to unregister listener.", (Throwable)e);
        }
    }

    private String getPluginVersion() {
        return Optional.ofNullable(this.pluginAccessor.getPlugin(PLUGIN_KEY)).map(plugin -> plugin.getPluginInformation().getVersion()).orElse(null);
    }

    private String getBaseUrl() {
        return this.baseUrl;
    }

    private String getConfluenceVersion() {
        return GeneralUtil.getVersionNumber();
    }

    private boolean isLicenseValid() {
        Option license = this.pluginLicenseManager.getLicense();
        return license.isDefined() && ((PluginLicense)license.get()).isValid();
    }
}

