/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.components;

import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.content.event.PluginContentCreatedEvent;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.moveworkforward.confluence.microsoftteams.notifier.actions.Source;
import com.moveworkforward.confluence.microsoftteams.notifier.components.ContentPermissionChecker;
import com.moveworkforward.confluence.microsoftteams.notifier.components.EventProcessorChecker;
import com.moveworkforward.confluence.microsoftteams.notifier.listeners.ConfluenceCalendarEventListener;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ConfluenceGlobalSettings;
import com.moveworkforward.confluence.microsoftteams.notifier.model.QuestionType;
import com.moveworkforward.confluence.microsoftteams.notifier.services.GlobalSettingsService;
import jakarta.inject.Inject;
import java.util.List;
import lombok.Generated;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EventProcessorCheckerImpl
implements EventProcessorChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventProcessorCheckerImpl.class);
    private static final boolean DO_NOT_CHECK_PERMISSIONS = false;
    private final GlobalSettingsService globalSettingsService;
    private final ContentPermissionChecker permissionChecker;

    @Inject
    public EventProcessorCheckerImpl(GlobalSettingsService globalSettingsService, ContentPermissionChecker permissionChecker) {
        this.globalSettingsService = globalSettingsService;
        this.permissionChecker = permissionChecker;
    }

    @Override
    public boolean shouldProcessEvent(ContentEvent event) {
        boolean result = true;
        ContentEntityObject content = this.extractContentFromEvent(event);
        Source source = null;
        try {
            source = Source.getSource(event);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        if (event.isSuppressNotifications() && !Source.PAGE_DELETED.equals((Object)source) && !Source.BLOGPOST_DELETED.equals((Object)source)) {
            log.debug("Page has suppress notifications. Don't notify");
            result = false;
        } else if (this.permissionChecker.doesContentHaveViewRestrictions(content)) {
            String spaceKey = this.extractSpaceKeyFromEvent(event);
            ConfluenceGlobalSettings globalSettings = (ConfluenceGlobalSettings)this.globalSettingsService.get(false);
            boolean allowNotificationsForViewRestrictedContent = globalSettings.isAllowNotificationsForViewRestrictedContent();
            if (allowNotificationsForViewRestrictedContent) {
                List<String> allowedSpaces = globalSettings.getSpacesWhereAllowedNotificationsForViewRestrictedContent();
                if (allowedSpaces.size() != 0) {
                    result = allowedSpaces.stream().anyMatch(x -> x.equalsIgnoreCase(spaceKey));
                    log.debug("Page has view restrictions. But the global settings allowNotificationsForViewRestrictedContent is TRUE. Space in list [{}]", (Object)result);
                }
            } else {
                result = false;
                log.debug("Page has view restrictions and the global settings allowNotificationsForViewRestrictedContent is FALSE.");
            }
        }
        return result;
    }

    private ContentEntityObject extractContentFromEvent(ContentEvent event) {
        ContentEntityObject result = event.getContent();
        if (event instanceof CommentEvent) {
            result = ((CommentEvent)event).getComment().getContainer();
        } else if (event instanceof AttachmentEvent) {
            result = ((AttachmentEvent)event).getAttachedTo();
        }
        return result;
    }

    private String extractSpaceKeyFromEvent(ContentEvent event) {
        CustomContentEntityObject content;
        String result = "05f11044-da77-41a8-ac66-a9388ffd0925";
        if (event instanceof CommentEvent) {
            result = ((CommentEvent)event).getComment().getSpace().getKey();
        } else if (event instanceof AttachmentEvent) {
            result = ((AttachmentEvent)event).getAttachment().getSpaceKey();
        } else if (event instanceof PageEvent) {
            result = ((PageEvent)event).getPage().getSpaceKey();
        } else if (event instanceof BlogPostEvent) {
            result = ((BlogPostEvent)event).getBlogPost().getSpaceKey();
        } else if (ConfluenceCalendarEventListener.isConfluenceCalendarEventStatic(event)) {
            try {
                PropertyUtilsBean propertyUtils = BeanUtilsBean.getInstance().getPropertyUtils();
                Object subCalendar = propertyUtils.getProperty((Object)event, "subCalendar");
                result = (String)propertyUtils.getProperty(subCalendar, "spaceKey");
            }
            catch (Exception error) {
                log.debug("Error parsing event", (Throwable)error);
            }
        } else if (event instanceof PluginContentCreatedEvent && (QuestionType.isQuestionEvent(content = ((PluginContentCreatedEvent)event).getContent()) || QuestionType.isAnswerEvent(content))) {
            result = content.getSpace().getKey();
        }
        return result;
    }
}

