/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.validators;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ConfigurationLevel;
import com.moveworkforward.confluence.microsoftteams.notifier.validators.AbstractConfluenceValidationHelper;
import com.moveworkforward.model.LevelPluginEntity;
import com.moveworkforward.model.SourcePluginEntity;
import com.moveworkforward.model.User;
import java.util.List;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GeneralConfluenceValidationHelper
extends AbstractConfluenceValidationHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeneralConfluenceValidationHelper.class);

    @Inject
    public GeneralConfluenceValidationHelper(@ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager) {
        super(permissionManager, spaceManager);
    }

    public boolean isSourceAdmin(Object space, User user) {
        ConfluenceUser confluenceUser = (ConfluenceUser)user.getUser();
        if (space == null && !this.permissionManager.isConfluenceAdministrator(confluenceUser)) {
            log.error("ConfluenceUser[key={}}] is not global admin", (Object)user.getDisplayName());
            return false;
        }
        if (space != null && !this.permissionManager.hasPermission(confluenceUser, Permission.ADMINISTER, space)) {
            log.error("ConfluenceUser[key=" + user.getDisplayName() + "] does not have permissions for reading from space {}", space);
            return false;
        }
        return true;
    }

    public <T extends LevelPluginEntity> boolean isPersonalLevel(T entity) {
        ConfigurationLevel level = (ConfigurationLevel)entity.getLevel();
        return ConfigurationLevel.PERSONAL.equals((Object)level);
    }

    public boolean isGlobalLevel(Object configuration) {
        LevelPluginEntity entity;
        ConfigurationLevel configurationLevel;
        if (configuration instanceof LevelPluginEntity && ((configurationLevel = (ConfigurationLevel)(entity = (LevelPluginEntity)configuration).getLevel()) == null || ConfigurationLevel.GLOBAL.equals((Object)configurationLevel))) {
            return true;
        }
        if (configuration instanceof SourcePluginEntity) {
            entity = (SourcePluginEntity)configuration;
            List sourceKeys = entity.getSourceKeys();
            if (sourceKeys.isEmpty()) {
                return true;
            }
            return sourceKeys.stream().anyMatch(s -> this.getGlobalKey().equalsIgnoreCase((String)s));
        }
        return true;
    }
}

