/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.validators;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.component.AbstractValidationHelper;
import com.moveworkforward.component.ValidationHelper;
import com.moveworkforward.model.ConfigurationLevel;
import com.moveworkforward.model.LevelPluginEntity;
import com.moveworkforward.model.SourcePluginEntity;
import com.moveworkforward.model.User;
import com.moveworkforward.model.UserPluginEntity;
import com.moveworkforward.service.DestinationValidator;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfluenceValidationHelper
extends AbstractValidationHelper
implements ValidationHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractConfluenceValidationHelper.class);
    protected final PermissionManager permissionManager;
    protected final SpaceManager spaceManager;
    protected DestinationValidator destinationValidator;

    public AbstractConfluenceValidationHelper(@ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager) {
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
    }

    public User getCurrentUser() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return Optional.ofNullable(confluenceUser).map(u -> new User(u, u.getKey().getStringValue(), u.getFullName())).orElse(new User());
    }

    public boolean isGlobalAdmin(User user) {
        return this.permissionManager.isConfluenceAdministrator((ConfluenceUser)user.getUser());
    }

    public void validateLevel(PluginEntity entity) {
        if (!(entity instanceof LevelPluginEntity)) {
            log.debug("Configuration is not designed for levels: {}", (Object)entity);
            return;
        }
        LevelPluginEntity configuration = (LevelPluginEntity)entity;
        if (com.moveworkforward.confluence.microsoftteams.notifier.model.ConfigurationLevel.PERSONAL.equals(configuration.getLevel())) {
            User user = this.getCurrentUser();
            String userKey = configuration.getOwner().getUserKey();
            if (StringUtils.isBlank((CharSequence)userKey)) {
                configuration.setOwner(user);
            }
            if (configuration instanceof UserPluginEntity) {
                ((UserPluginEntity)configuration).setUsers(Arrays.asList(user));
            }
        } else if (com.moveworkforward.confluence.microsoftteams.notifier.model.ConfigurationLevel.SPACE.equals(configuration.getLevel())) {
            if (StringUtils.isEmpty((CharSequence)configuration.getSourceKey())) {
                throw new IllegalArgumentException("Space key is not set");
            }
            if (configuration instanceof SourcePluginEntity) {
                SourcePluginEntity sourceConfiguration = (SourcePluginEntity)configuration;
                if (sourceConfiguration.getSourceKeys().stream().anyMatch(s -> !configuration.getSourceKey().equals(s))) {
                    throw new IllegalArgumentException("Space level configuration can not contain other space keys");
                }
                if (sourceConfiguration.getSourceKeys().stream().anyMatch(s -> s.equalsIgnoreCase(this.getGlobalKey()))) {
                    throw new IllegalArgumentException("Configuration should not contain Global space key");
                }
                sourceConfiguration.setSourceKeys(Arrays.asList(configuration.getSourceKey()));
            }
        } else {
            configuration.setLevel((ConfigurationLevel)com.moveworkforward.confluence.microsoftteams.notifier.model.ConfigurationLevel.GLOBAL);
            if (configuration instanceof SourcePluginEntity) {
                SourcePluginEntity sourceConfiguration = (SourcePluginEntity)configuration;
                List spaceKeys = sourceConfiguration.getSourceKeys();
                sourceConfiguration.setSourceKeys(spaceKeys);
            }
            configuration.setSourceKey(this.getGlobalKey());
        }
    }

    public String getGlobalKey() {
        return "05f11044-da77-41a8-ac66-a9388ffd0925";
    }

    public Space getSourceByKey(String spaceKey) {
        Space space = null;
        try {
            space = this.spaceManager.getSpace(spaceKey);
        }
        catch (Exception e) {
            log.error("Space is not found by key: {}", (Object)spaceKey);
        }
        return space;
    }

    public <T extends LevelPluginEntity> boolean isOwner(T entity, User user) {
        String expectedUserKey = Optional.ofNullable(user).map(User::getUserKey).orElse(null);
        String targetUserKey = Optional.ofNullable(entity).map(LevelPluginEntity::getOwner).map(User::getUserKey).orElse(null);
        return expectedUserKey != null & targetUserKey != null && expectedUserKey.equals(targetUserKey);
    }

    public <T extends LevelPluginEntity> boolean isSourceLevel(T configuration, String spaceKey) {
        if (StringUtils.isBlank((CharSequence)spaceKey)) {
            return true;
        }
        if (this.isGlobalSourceKey(spaceKey)) {
            return this.isGlobalLevel(configuration);
        }
        if ((this.isGlobalLevel(configuration) || this.isPersonalLevel(configuration) && this.isOwner(configuration, this.getCurrentUser())) && this.isSourceMatched(configuration, spaceKey)) {
            return true;
        }
        return com.moveworkforward.confluence.microsoftteams.notifier.model.ConfigurationLevel.SPACE.equals(configuration.getLevel()) && spaceKey.equals(configuration.getSourceKey());
    }

    private <T extends LevelPluginEntity> boolean isSourceMatched(T configuration, String spaceKey) {
        if (configuration instanceof SourcePluginEntity) {
            SourcePluginEntity entity = (SourcePluginEntity)configuration;
            List sourceKeys = entity.getSourceKeys();
            if (sourceKeys.isEmpty()) {
                return true;
            }
            return sourceKeys.stream().anyMatch(s -> this.getGlobalKey().equalsIgnoreCase((String)s) || spaceKey.equals(s));
        }
        return false;
    }

    public boolean isGlobalSourceKey(String sourceKey) {
        return this.getGlobalKey().equalsIgnoreCase(sourceKey) || "f94a2448-696d-4d81-ae30-4e2054daf97f".equalsIgnoreCase(sourceKey);
    }

    @Generated
    public void setDestinationValidator(DestinationValidator destinationValidator) {
        this.destinationValidator = destinationValidator;
    }

    @Generated
    public DestinationValidator getDestinationValidator() {
        return this.destinationValidator;
    }
}

