/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.services;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.confluence.microsoftteams.notifier.services.ContentPermissionChecker;
import jakarta.inject.Inject;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class DefaultContentPermissionChecker
implements ContentPermissionChecker {
    private final ContentPermissionManager contentPermissionManager;

    @Inject
    public DefaultContentPermissionChecker(@ComponentImport ContentPermissionManager contentPermissionManager) {
        this.contentPermissionManager = contentPermissionManager;
    }

    @Override
    public boolean doesContentHaveViewRestrictions(ContentEntityObject content) {
        List permissionSets = this.contentPermissionManager.getContentPermissionSets(content, "View");
        for (ContentPermissionSet permissionSet : permissionSets) {
            if (permissionSet.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

