/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.services;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ContentStatisticReportConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsData;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsEvent;
import com.moveworkforward.confluence.microsoftteams.notifier.repository.ContentStatisticReportConfigurationRepository;
import com.moveworkforward.confluence.microsoftteams.notifier.services.AbstractStatisticsReportConfigurationService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.StatisticService;
import com.moveworkforward.confluence.microsoftteams.notifier.validators.GeneralConfluenceValidationHelper;
import com.moveworkforward.service.OperationListener;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ContentStatisticReportConfigurationService
extends AbstractStatisticsReportConfigurationService<ContentStatisticReportConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContentStatisticReportConfigurationService.class);
    public static final String LABELS = "labels";
    public static final String AUTHOR_GROUPS = "authorGroups";
    private static final int MAX_COUNT = 10;

    @Inject
    public ContentStatisticReportConfigurationService(ContentStatisticReportConfigurationRepository repository, List<OperationListener> operationListeners, GeneralConfluenceValidationHelper validationHelper, @ComponentImport UserAccessor userAccessor, @ComponentImport PageManager pageManager, @ComponentImport SpaceManager spaceManager) {
        super(repository, operationListeners, validationHelper, userAccessor, pageManager, spaceManager);
    }

    @Override
    public void validate(ContentStatisticReportConfiguration configuration) {
        super.validate(configuration);
        if (configuration.getContentAmount() <= 0 || configuration.getContentAmount() > 10) {
            throw new IllegalArgumentException("Content amount must be greater than 0 and less or equal to 10");
        }
        if (CollectionUtils.isEmpty(configuration.getSectionTypes())) {
            throw new IllegalArgumentException("At least one section must be defined: " + Stream.of(ContentStatisticReportConfiguration.SectionType.values()).map(Enum::toString).collect(Collectors.joining(", ")));
        }
    }

    @Override
    protected void validateSources(ContentStatisticReportConfiguration configuration) {
        configuration.getSources().forEach(s -> {
            if ((StringUtils.isBlank((CharSequence)s.getSpaceKey()) || "05f11044-da77-41a8-ac66-a9388ffd0925".equals(s.getSpaceKey())) && (s.getContentType() == null || s.getContentId() == null)) {
                throw new IllegalArgumentException("Space key or Content type and content ID must be specified");
            }
        });
    }

    public String getType() {
        return "content-report";
    }

    public Class<ContentStatisticReportConfiguration> getConfigurationClass() {
        return ContentStatisticReportConfiguration.class;
    }

    @Override
    protected void doEnhancement(ContentStatisticReportConfiguration configuration) {
        super.doEnhancement(configuration);
        this.enrichUsers(configuration.getAuthors());
    }

    @Override
    public boolean shouldProcess(StatisticsEvent statisticsEvent) {
        ContentEntityObject content = StatisticService.getContainerContentEntity(statisticsEvent.getContentEvent().getContent());
        StatisticsData.ContentType contentType = StatisticService.getContentType(content);
        String spaceKey = content instanceof SpaceContentEntityObject ? ((SpaceContentEntityObject)content).getSpaceKey() : null;
        long contentId = content.getId();
        List configurations = this.pluginRepository.getAll();
        boolean result = configurations.stream().anyMatch(c -> !CollectionUtils.isEmpty((Collection)c.getSources()) && c.getSources().stream().anyMatch(s -> {
            boolean res;
            boolean bl = res = StringUtils.isNotBlank((CharSequence)s.getSpaceKey()) && s.getSpaceKey().equals(spaceKey);
            if (s.getContentType() != null && s.getContentId() != null) {
                res = contentType.equals((Object)s.getContentType()) && contentId == s.getContentId();
            }
            return res;
        }));
        log.debug("Content type: {}, content ID: {}, should process: {}", new Object[]{contentType, contentId, result});
        return result;
    }

    @Override
    public Map<String, Object> getAdditionalInfo(StatisticsEvent statisticsEvent) {
        ContentEntityObject content = StatisticService.getContainerContentEntity(statisticsEvent.getContentEvent().getContent());
        HashMap<String, Object> additionalInfo = new HashMap<String, Object>();
        additionalInfo.put(LABELS, content.getLabels().stream().map(Label::getName).collect(Collectors.toList()));
        ConfluenceUser author = content.getCreator();
        additionalInfo.put(AUTHOR_GROUPS, this.userAccessor.getGroupNames((User)author));
        return additionalInfo;
    }
}

