/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.services;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.confluence.microsoftteams.notifier.services.GlobalSettingsService;
import com.moveworkforward.model.MessageAudit;
import com.moveworkforward.service.impl.AbstractMessageAuditService;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceMessageAuditService
extends AbstractMessageAuditService {
    public static final int MESSAGE_COUNT = 300;
    private final PermissionManager permissionManager;
    private final SpaceManager spaceManager;

    @Inject
    public ConfluenceMessageAuditService(@ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, GlobalSettingsService globalSettingsService) {
        super((com.moveworkforward.service.GlobalSettingsService)globalSettingsService);
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
    }

    protected List<MessageAudit> filterByUserPermissions(Collection<MessageAudit> collect) {
        HashMap spacesPermissions = new HashMap();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        List<MessageAudit> result = collect.stream().filter(messageAudit -> spacesPermissions.computeIfAbsent(messageAudit.getTag(), s -> {
            Space space = this.spaceManager.getSpace(s);
            return this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)space);
        })).collect(Collectors.toList());
        return result;
    }

    protected void hasUserAdminPermissions() {
        if (!this.permissionManager.isConfluenceAdministrator(AuthenticatedUserThreadLocal.get())) {
            throw new RuntimeException("User doesn't have permissions");
        }
    }

    protected int getLimit() {
        return 300;
    }
}

