/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.report;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.moveworkforward.confluence.microsoftteams.notifier.model.HistoricalStatisticsData;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ProgressStatisticDataHolder;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ProgressStatisticReportConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsData;
import com.moveworkforward.confluence.microsoftteams.notifier.report.AbstractReportCreator;
import com.moveworkforward.model.teams.MessageData;
import com.moveworkforward.model.teams.payload.Message;
import com.moveworkforward.util.TeamsPayloadUtils;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProgressStatisticReportCreator
extends AbstractReportCreator<ProgressStatisticReportConfiguration, ProgressStatisticDataHolder> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProgressStatisticReportCreator.class);

    @Inject
    protected ProgressStatisticReportCreator(@ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider) {
        super(i18nResolver, webResourceUrlProvider);
    }

    @Override
    public String createPayload(ProgressStatisticReportConfiguration configuration, ProgressStatisticDataHolder payloadHolder) {
        String subTitle = this.getPeriodString(configuration.getTimePeriod());
        String showText = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.show");
        String hideText = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.hide");
        MessageData messageData = new MessageData(configuration.getName(), subTitle, null);
        messageData.getItems().add(new MessageData.Item("items", "", showText, hideText, this.getItems(payloadHolder.getData())));
        Message message = TeamsPayloadUtils.createToggleableItemsMessage((MessageData)messageData);
        String payload = this.objectMapper.writeValueAsString((Object)message);
        log.debug("Progress statistics report payload: {}", (Object)payload);
        return payload;
    }

    private List<String> getItems(List<Pair<StatisticsData, HistoricalStatisticsData>> data) {
        String baseUrl = this.getBaseUrl();
        ArrayList<String> items = new ArrayList<String>();
        data.forEach(d -> {
            StatisticsData currentStatistics = (StatisticsData)((Object)((Object)d.getKey()));
            StatisticsData previousStatistics = Optional.ofNullable((HistoricalStatisticsData)((Object)((Object)d.getValue()))).map(HistoricalStatisticsData::getStatisticsData).orElse(new StatisticsData());
            String item = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.progress", new Serializable[]{TeamsPayloadUtils.makeMicrosoftTeamsLink((String)currentStatistics.getTitle(), (String)(baseUrl + currentStatistics.getUrlPath())), Integer.valueOf(currentStatistics.getViewCount()), this.getProgress(currentStatistics.getViewCount(), previousStatistics.getViewCount()), Integer.valueOf(currentStatistics.getLikeCount()), this.getProgress(currentStatistics.getLikeCount(), previousStatistics.getLikeCount()), Integer.valueOf(currentStatistics.getCommentCount()), this.getProgress(currentStatistics.getCommentCount(), previousStatistics.getCommentCount()), Integer.valueOf(currentStatistics.getEditCount()), this.getProgress(currentStatistics.getEditCount(), previousStatistics.getEditCount())});
            items.add(item);
        });
        return items;
    }

    private String getProgress(int currentCount, int previousCount) {
        int delta = currentCount - previousCount;
        return (delta > 0 ? "+" : (delta < 0 ? "-" : "")) + delta;
    }
}

