/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.report;

import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ContentStatisticReportConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.model.ContentStatisticsDataHolder;
import com.moveworkforward.confluence.microsoftteams.notifier.model.MatchingStrategy;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsData;
import com.moveworkforward.confluence.microsoftteams.notifier.report.AbstractReportExecutor;
import com.moveworkforward.confluence.microsoftteams.notifier.report.ContentStatisticsReportCreator;
import com.moveworkforward.confluence.microsoftteams.notifier.services.AbstractStatisticsReportConfigurationService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.ContentStatisticReportConfigurationService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.StatisticService;
import com.moveworkforward.confluence.microsoftteams.notifier.services.UrlConfigurationServiceImpl;
import com.moveworkforward.confluence.microsoftteams.notifier.util.FilterUtils;
import com.moveworkforward.model.User;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ContentStatisticsReportExecutor
extends AbstractReportExecutor<ContentStatisticReportConfiguration, ContentStatisticsDataHolder> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContentStatisticsReportExecutor.class);
    private final StatisticService statisticService;

    @Inject
    public ContentStatisticsReportExecutor(ContentStatisticReportConfigurationService configurationService, UrlConfigurationServiceImpl urlConfigurationService, ContentStatisticsReportCreator reportCreator, StatisticService statisticService) {
        super(configurationService, urlConfigurationService, reportCreator);
        this.statisticService = statisticService;
        this.isReschedule = true;
    }

    @Override
    protected ContentStatisticsDataHolder getPayloadDataByConfiguration(ContentStatisticReportConfiguration configuration, Date date) {
        List<ContentStatisticReportConfiguration.SectionType> sectionTypes = configuration.getSectionTypes();
        ContentStatisticsDataHolder dataHolder = new ContentStatisticsDataHolder();
        sectionTypes.forEach(sectionType -> {
            switch (sectionType) {
                case NEW: {
                    dataHolder.setCreatedData(this.getCreatedContent(configuration, date));
                    break;
                }
                case STALE: {
                    dataHolder.setStaleData(this.getStaleContent(configuration, date));
                    break;
                }
                case POPULAR: {
                    dataHolder.setStatisticsData(this.getStatisticsContent(configuration));
                }
            }
        });
        log.debug("Statistics found {} for configuration {}", (Object)dataHolder, (Object)configuration);
        return dataHolder;
    }

    private Set<StatisticsData> getStatisticsContent(ContentStatisticReportConfiguration configuration) {
        HashSet<StatisticsData> data = new HashSet<StatisticsData>();
        configuration.getSources().forEach(source -> {
            StatisticsData sd2;
            if (StringUtils.isNotBlank((CharSequence)source.getSpaceKey()) && (source.getContentType() == null || source.getContentId() == null)) {
                ArrayList<StatisticsData> statisticsData = new ArrayList<StatisticsData>(this.statisticService.getByTag(source.getSpaceKey(), false));
                if (CollectionUtils.isNotEmpty(statisticsData)) {
                    statisticsData.removeIf(sd -> !this.isAccepted((StatisticsData)((Object)((Object)sd)), configuration));
                    data.addAll(statisticsData);
                }
            } else if ((source.getContentType() != null || source.getContentId() != null) && (sd2 = this.statisticService.get(source.getContentType(), source.getContentId())) != null && this.isAccepted(sd2, configuration)) {
                data.add(sd2);
            }
        });
        return FilterUtils.trim(FilterUtils.sortByPopularity(data), configuration.getContentAmount());
    }

    private Set<StatisticsData> getStaleContent(ContentStatisticReportConfiguration configuration, Date date) {
        HashSet<StatisticsData> data = new HashSet<StatisticsData>();
        configuration.getSources().forEach(source -> {
            if (StringUtils.isNotBlank((CharSequence)source.getSpaceKey()) && (source.getContentType() == null || source.getContentId() == null)) {
                List<Page> pages = ((AbstractStatisticsReportConfigurationService)this.configurationService).getPages(source.getSpaceKey());
                List<BlogPost> blogPosts = ((AbstractStatisticsReportConfigurationService)this.configurationService).getBlogPosts(source.getSpaceKey());
                pages.forEach(page -> this.collectStaleData(source.getSpaceKey(), StatisticsData.ContentType.PAGE, page.getId(), configuration, data, date));
                blogPosts.forEach(blogPost -> this.collectStaleData(source.getSpaceKey(), StatisticsData.ContentType.BLOG_POST, blogPost.getId(), configuration, data, date));
            } else if (source.getContentType() != null || source.getContentId() != null) {
                this.collectStaleData(source.getSpaceKey(), source.getContentType(), source.getContentId(), configuration, data, date);
            }
        });
        return FilterUtils.trim(FilterUtils.sortByPopularity(data), configuration.getContentAmount());
    }

    private void collectStaleData(String spaceKey, StatisticsData.ContentType contentType, long id, ContentStatisticReportConfiguration configuration, Collection<StatisticsData> data, Date date) {
        long startMillis = new DateTime((Object)date).minus((ReadableDuration)configuration.getTimePeriod().getPeriod().toStandardDuration()).getMillis();
        StatisticsData sd = Optional.ofNullable(this.statisticService.get(contentType, id)).orElseGet(() -> {
            StatisticsData statisticsData = new StatisticsData(spaceKey, contentType, id);
            SpaceContentEntityObject contentObject = ((AbstractStatisticsReportConfigurationService)this.configurationService).getContentEntity(id);
            if (contentObject != null) {
                statisticsData.getAdditionalInfo().put("spaceName", contentObject.getSpace().getName());
                statisticsData.setUrlPath(contentObject.getUrlPath());
                statisticsData.setTitle(contentObject.getTitle());
                Optional.ofNullable(contentObject.getCreator()).ifPresent(user -> statisticsData.setAuthor(new User(user, user.getKey().getStringValue(), user.getFullName())));
                Optional.ofNullable(contentObject.getLabels()).ifPresent(labels -> {
                    List contentLabels = labels.stream().map(Label::getName).collect(Collectors.toList());
                    statisticsData.getAdditionalInfo().put("labels", contentLabels);
                });
            }
            return statisticsData;
        });
        long lastActionTime = LongStream.of(sd.getCommentTimestamp(), sd.getViewTimestamp(), sd.getEditTimestamp(), sd.getLikeTimestamp()).max().getAsLong();
        if (lastActionTime < startMillis && this.isAccepted(sd, configuration)) {
            data.add(sd);
        }
    }

    private Set<StatisticsData> getCreatedContent(ContentStatisticReportConfiguration configuration, Date date) {
        long startMillis = new DateTime((Object)date).minus((ReadableDuration)configuration.getTimePeriod().getPeriod().toStandardDuration()).getMillis();
        LinkedHashSet data = new LinkedHashSet();
        configuration.getSources().forEach(source -> {
            if (StringUtils.isNotBlank((CharSequence)source.getSpaceKey()) && (source.getContentType() == null || source.getContentId() == null)) {
                List statisticsData = this.statisticService.getByTag(source.getSpaceKey(), false);
                statisticsData.forEach(sd -> {
                    if (startMillis <= sd.getCreateTimestamp() && this.isAccepted((StatisticsData)((Object)((Object)sd)), configuration)) {
                        data.add(sd);
                    }
                });
            }
        });
        return FilterUtils.trim(data, configuration.getContentAmount());
    }

    private boolean isAccepted(StatisticsData statisticsData, ContentStatisticReportConfiguration configuration) {
        List<User> authors = configuration.getAuthors();
        List groups = configuration.getGroups();
        List<String> labels = configuration.getLabels();
        MatchingStrategy strategy = configuration.getLabelMatchingStrategy() == null ? MatchingStrategy.ALL : configuration.getLabelMatchingStrategy();
        ContentStatisticReportConfigurationService contentConfigurationService = (ContentStatisticReportConfigurationService)this.configurationService;
        Optional<SpaceContentEntityObject> optional = Optional.ofNullable(contentConfigurationService.getContentEntity(statisticsData.getContentType(), statisticsData.getContentId()));
        Map<String, Object> additionalInfo = statisticsData.getAdditionalInfo();
        User contentAuthor = Optional.ofNullable(statisticsData.getAuthor()).orElse(new User());
        List authorGroups = (List)additionalInfo.get("authorGroups");
        List contentLabels = optional.map(e -> e.getLabels().stream().map(Label::getName).collect(Collectors.toList())).orElse(new ArrayList());
        additionalInfo.put("labels", contentLabels);
        return FilterUtils.isUserAccepted(authors, contentAuthor, "Author") && FilterUtils.isGroupAccepted(groups, authorGroups) && FilterUtils.isLabelAccepted(labels, strategy, contentLabels);
    }
}

