/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.listeners;

import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.content.event.PluginContentCreatedEvent;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.moveworkforward.confluence.microsoftteams.notifier.api.EventNotifier;
import com.moveworkforward.confluence.microsoftteams.notifier.components.EventProcessorChecker;
import com.moveworkforward.confluence.microsoftteams.notifier.listeners.AutoSubscribingEventListener;
import com.moveworkforward.confluence.microsoftteams.notifier.model.QuestionAndAnswerEventInfo;
import com.moveworkforward.confluence.microsoftteams.notifier.model.QuestionType;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceQuestionsAndAnswersEventListener
extends AutoSubscribingEventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfluenceQuestionsAndAnswersEventListener.class);
    private static final int POOL_SIZE = 10;
    private static final long QUESTION_DELAY = 2L;
    private final EventNotifier eventNotifier;
    private final EventProcessorChecker eventProcessorChecker;
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(10);
    private final SpaceManager spaceManager;

    @Inject
    public ConfluenceQuestionsAndAnswersEventListener(EventPublisher eventPublisher, EventNotifier eventNotifier, EventProcessorChecker eventProcessorChecker, SpaceManager spaceManager) {
        super(eventPublisher);
        this.eventNotifier = eventNotifier;
        this.eventProcessorChecker = eventProcessorChecker;
        this.spaceManager = spaceManager;
    }

    @EventListener
    public void questionOrAnswerEvent(ConfluenceEvent event) {
        Optional<QuestionType> questionTypeOptional = QuestionType.from(event);
        if (!questionTypeOptional.isPresent()) {
            return;
        }
        try {
            this.processEvent(event, questionTypeOptional.get());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @EventListener
    public void questionOrAnswerEvent(PluginContentCreatedEvent event) {
        CustomContentEntityObject content = event.getContent();
        Optional<QuestionType> questionTypeOptional = QuestionType.from(content);
        if (!questionTypeOptional.isPresent() || !this.eventProcessorChecker.shouldProcessEvent((ContentEvent)event)) {
            return;
        }
        if (QuestionType.QUESTION.equals((Object)questionTypeOptional.get())) {
            this.executorService.schedule(() -> this.processEvent(content, (QuestionType)((Object)((Object)questionTypeOptional.get()))), 2L, TimeUnit.SECONDS);
        } else {
            this.processEvent(content, questionTypeOptional.get());
        }
    }

    private void processEvent(ConfluenceEvent confluenceEvent, QuestionType questionType) {
        PropertyUtilsBean propertyUtils = BeanUtilsBean.getInstance().getPropertyUtils();
        Object question = this.getPropertySafe(propertyUtils, confluenceEvent, "question");
        if (question == null) {
            log.debug("Can't find the question object");
            return;
        }
        long questionId = (Long)this.getPropertySafe(propertyUtils, question, "id");
        String spaceKey = (String)this.getPropertySafe(propertyUtils, question, "spaceKey");
        ArrayList<String> topics = new ArrayList();
        String body = "";
        String title = null;
        String urlPath = (String)(StringUtils.isBlank((CharSequence)spaceKey) ? "" : "/display/" + spaceKey) + "/qa/questions/" + questionId;
        ConfluenceUser trigger = (ConfluenceUser)this.getPropertySafe(propertyUtils, confluenceEvent, "trigger");
        if (questionType == QuestionType.ANSWER) {
            Object answer = this.getPropertySafe(propertyUtils, confluenceEvent, "answer");
            body = (String)this.getPropertySafe(propertyUtils, answer, "bodyText");
            spaceKey = (String)this.getPropertySafe(propertyUtils, answer, "spaceKey");
            long answerId = (Long)this.getPropertySafe(propertyUtils, answer, "id");
            urlPath = (String)(StringUtils.isBlank((CharSequence)spaceKey) ? "" : "/display/" + spaceKey) + "/qa/questions/" + questionId + "/answers/" + answerId;
        } else if (questionType == QuestionType.QUESTION) {
            title = (String)this.getPropertySafe(propertyUtils, question, "title");
            body = (String)this.getPropertySafe(propertyUtils, question, "bodyText");
            topics = (List)this.getPropertySafe(propertyUtils, question, "tagNames");
        }
        String abbreviateContent = StringUtils.abbreviate((String)body, (int)200);
        Space space = this.spaceManager.getSpace(spaceKey);
        QuestionAndAnswerEventInfo eventInfo = new QuestionAndAnswerEventInfo();
        eventInfo.setTrigger(trigger);
        eventInfo.setSpace(space);
        eventInfo.setQuestionType(questionType);
        eventInfo.setAbbreviateContent(abbreviateContent);
        eventInfo.setTitle(title);
        eventInfo.setUrlPath(urlPath);
        eventInfo.setTopics(topics);
        this.eventNotifier.notifyQuestionAndAnswerEvent(eventInfo);
    }

    private void processEvent(CustomContentEntityObject content, QuestionType questionType) {
        String abbreviateContent = StringUtils.abbreviate((String)content.getBodyAsString(), (int)200);
        if (questionType == QuestionType.ANSWER) {
            abbreviateContent = StringUtils.abbreviate((String)this.getAnswerContent((SpaceContentEntityObject)content), (int)200);
        }
        String title = null;
        if (questionType == QuestionType.QUESTION) {
            title = content.getDisplayTitle();
        }
        QuestionAndAnswerEventInfo eventInfo = new QuestionAndAnswerEventInfo();
        eventInfo.setTrigger(content.getCreator());
        eventInfo.setSpace(content.getSpace());
        eventInfo.setQuestionType(questionType);
        eventInfo.setAbbreviateContent(abbreviateContent);
        eventInfo.setTitle(title);
        eventInfo.setUrlPath(this.getURL(content));
        eventInfo.setTopics(this.getTopics(content, questionType));
        this.eventNotifier.notifyQuestionAndAnswerEvent(eventInfo);
    }

    private Object getPropertySafe(PropertyUtilsBean propertyUtils, Object target, String propertyName) {
        try {
            return propertyUtils.getProperty(target, propertyName);
        }
        catch (Exception e) {
            log.warn("Can't get property {} from {}", (Object)propertyName, target);
            return null;
        }
    }

    private String getURL(CustomContentEntityObject content) {
        try {
            return content.getUrlPath();
        }
        catch (Exception e) {
            return "questions/" + content.getIdAsString();
        }
    }

    private String getAnswerContent(SpaceContentEntityObject content) {
        if (content instanceof CustomContentEntityObject && QuestionType.isAnswerEvent((CustomContentEntityObject)content)) {
            return StringUtils.abbreviate((String)content.getBodyAsString(), (int)200);
        }
        return null;
    }

    private List<String> getTopics(CustomContentEntityObject content, QuestionType questionType) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (CustomContentEntityObject customContentEntityObject = content; customContentEntityObject != null; customContentEntityObject = customContentEntityObject.getParent()) {
            result.addAll(this.getLabels(customContentEntityObject));
        }
        return new ArrayList<String>(result);
    }

    private Set<String> getLabels(CustomContentEntityObject content) {
        if (content == null) {
            return Collections.emptySet();
        }
        return content.getLabels().stream().map(Label::getName).collect(Collectors.toSet());
    }
}

