/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.listeners;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.confluence.microsoftteams.notifier.actions.Source;
import com.moveworkforward.confluence.microsoftteams.notifier.api.EventNotifier;
import com.moveworkforward.confluence.microsoftteams.notifier.listeners.AutoSubscribingEventListener;
import com.moveworkforward.confluence.microsoftteams.notifier.model.CalendarEventInfo;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceCalendarEventListener
extends AutoSubscribingEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfluenceCalendarEventListener.class);
    private static final String CONFLUENCE_CALENDAR_EVENT_CREATED = "com.atlassian.confluence.extra.calendar3.events.SubCalendarEventCreated";
    private static final String CONFLUENCE_CALENDAR_EVENT_UPDATED = "com.atlassian.confluence.extra.calendar3.events.SubCalendarEventUpdated";
    private static final String CONFLUENCE_CALENDAR_EVENT_REMOVED = "com.atlassian.confluence.extra.calendar3.events.SubCalendarEventRemoved";
    private static final List<String> CONFLUENCE_CALENDAR_EVENT_CLASSES = Collections.unmodifiableList(Arrays.asList("com.atlassian.confluence.extra.calendar3.events.SubCalendarEventCreated", "com.atlassian.confluence.extra.calendar3.events.SubCalendarEventUpdated", "com.atlassian.confluence.extra.calendar3.events.SubCalendarEventRemoved"));
    private final EventNotifier eventNotifier;

    @Inject
    public ConfluenceCalendarEventListener(@ComponentImport EventPublisher eventPublisher, EventNotifier eventNotifier) {
        super(eventPublisher);
        this.eventNotifier = eventNotifier;
    }

    @EventListener
    public void calendarEvent(Object event) {
        if (this.isConfluenceCalendarEvent(event)) {
            Optional<CalendarEventInfo> eventInfo = this.getEventInfo(event);
            eventInfo.ifPresent(this.eventNotifier::notifyCalendarEvent);
        }
    }

    public static boolean isConfluenceCalendarEventStatic(Object event) {
        return CONFLUENCE_CALENDAR_EVENT_CLASSES.contains(event.getClass().getName());
    }

    protected boolean isConfluenceCalendarEvent(Object event) {
        return ConfluenceCalendarEventListener.isConfluenceCalendarEventStatic(event);
    }

    private Optional<CalendarEventInfo> getEventInfo(Object event) {
        try {
            PropertyUtilsBean propertyUtils = BeanUtilsBean.getInstance().getPropertyUtils();
            Object innerEvent = propertyUtils.getProperty(event, "event");
            ConfluenceUser trigger = (ConfluenceUser)propertyUtils.getProperty(event, "trigger");
            String typeName = (String)propertyUtils.getProperty(innerEvent, "eventTypeName");
            String description = (String)propertyUtils.getProperty(innerEvent, "description");
            String name = (String)propertyUtils.getProperty(innerEvent, "name");
            boolean allDay = (Boolean)propertyUtils.getProperty(innerEvent, "allDay");
            long startTime = (Long)propertyUtils.getProperty(propertyUtils.getProperty(innerEvent, "startTime"), "millis");
            long endTime = (Long)propertyUtils.getProperty(propertyUtils.getProperty(innerEvent, "endTime"), "millis");
            Set<ConfluenceUser> invitees = ((Set)ObjectUtils.defaultIfNull((Object)propertyUtils.getProperty(innerEvent, "invitees"), Collections.emptySet())).stream().flatMap(invitee -> {
                try {
                    return Stream.of(propertyUtils.getProperty(invitee, "user"));
                }
                catch (Exception e) {
                    LOGGER.debug("Error parsing event", (Throwable)e);
                    return Stream.empty();
                }
            }).collect(Collectors.toSet());
            Object subCalendar = propertyUtils.getProperty(event, "subCalendar");
            String calendarName = (String)propertyUtils.getProperty(subCalendar, "name");
            String timeZoneId = (String)propertyUtils.getProperty(subCalendar, "timeZoneId");
            String spaceKey = (String)propertyUtils.getProperty(subCalendar, "spaceKey");
            CalendarEventInfo eventInfo = new CalendarEventInfo();
            eventInfo.setAllDay(allDay);
            eventInfo.setCalendarName(calendarName);
            eventInfo.setDescription(description);
            eventInfo.setEndTime(endTime);
            eventInfo.setInvitees(invitees);
            eventInfo.setName(name);
            eventInfo.setSpaceKey(spaceKey);
            eventInfo.setTrigger(trigger);
            eventInfo.setTypeName(typeName);
            eventInfo.setStartTime(startTime);
            eventInfo.setTimeZoneId(timeZoneId);
            if (CONFLUENCE_CALENDAR_EVENT_CREATED.equals(event.getClass().getName())) {
                eventInfo.setSource(Source.CALENDAR_EVENT_CREATED);
            } else if (CONFLUENCE_CALENDAR_EVENT_UPDATED.equals(event.getClass().getName())) {
                eventInfo.setSource(Source.CALENDAR_EVENT_UPDATED);
            } else if (CONFLUENCE_CALENDAR_EVENT_REMOVED.equals(event.getClass().getName())) {
                eventInfo.setSource(Source.CALENDAR_EVENT_DELETED);
            }
            return Optional.of(eventInfo);
        }
        catch (Exception error) {
            LOGGER.debug("Error parsing event", (Throwable)error);
            return Optional.empty();
        }
    }
}

