/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.services;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.moveworkforward.ao.PluginRepository;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.component.ValidationHelper;
import com.moveworkforward.confluence.microsoftteams.notifier.services.ConfluenceConfigurationService;
import com.moveworkforward.model.User;
import com.moveworkforward.service.OperationListener;
import com.moveworkforward.service.impl.AbstractConfigurationService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractConfluenceConfigurationService<T extends PluginEntity>
extends AbstractConfigurationService<T>
implements ConfluenceConfigurationService<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractConfluenceConfigurationService.class);
    protected final UserAccessor userAccessor;

    public AbstractConfluenceConfigurationService(PluginRepository<T> pluginRepository, List<OperationListener> operationListeners, ValidationHelper validationHelper, UserAccessor userAccessor) {
        super(pluginRepository, operationListeners, validationHelper);
        this.userAccessor = userAccessor;
    }

    public boolean isSpaceAdmin(String spaceKey, ConfluenceUser user) {
        return this.validationHelper.isSourceAdmin((Object)spaceKey, new User((Object)user, user.getKey().getStringValue(), user.getName()));
    }

    @Override
    public T deleteByKey(String key) {
        PluginEntity existingConfiguration = this.pluginRepository.getByKey(key);
        return (T)super.delete(existingConfiguration.getId().intValue(), true);
    }

    protected void enrichUsers(List<User> users) {
        if (CollectionUtils.isEmpty(users)) {
            return;
        }
        users.forEach(this::enrichUser);
    }

    protected User enrichUser(User user) {
        try {
            if (user == null) {
                return user;
            }
            ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(new UserKey(user.getUserKey()));
            if (confluenceUser != null) {
                user.setDisplayName(confluenceUser.getFullName());
                user.setUser((Object)confluenceUser);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return user;
    }

    protected abstract List<String> getSpaceKeys(T var1);
}

