/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.microsoftteams.notifier.report;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.moveworkforward.confluence.microsoftteams.notifier.model.StatisticsData;
import com.moveworkforward.confluence.microsoftteams.notifier.model.TopItemsDataHolder;
import com.moveworkforward.confluence.microsoftteams.notifier.model.TopItemsReportConfiguration;
import com.moveworkforward.confluence.microsoftteams.notifier.report.AbstractReportCreator;
import com.moveworkforward.model.teams.MessageData;
import com.moveworkforward.model.teams.payload.Message;
import com.moveworkforward.util.TeamsPayloadUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TopItemsReportCreator
extends AbstractReportCreator<TopItemsReportConfiguration, TopItemsDataHolder> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopItemsReportCreator.class);

    @Inject
    protected TopItemsReportCreator(@ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider) {
        super(i18nResolver, webResourceUrlProvider);
    }

    @Override
    public String createPayload(TopItemsReportConfiguration configuration, TopItemsDataHolder payloadHolder) {
        String sectionTitle;
        String subTitle = this.getPeriodString(configuration.getTimePeriod());
        String showText = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.show");
        String hideText = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.hide");
        MessageData messageData = new MessageData(configuration.getName(), subTitle, null);
        if (CollectionUtils.isNotEmpty(payloadHolder.getTopAuthors())) {
            sectionTitle = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.top.author");
            messageData.getItems().add(new MessageData.Item("top_author", sectionTitle, showText, hideText, this.getTopAuthors(payloadHolder.getTopAuthors())));
        }
        if (CollectionUtils.isNotEmpty(payloadHolder.getTopContributors())) {
            sectionTitle = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.top.contributors");
            messageData.getItems().add(new MessageData.Item("top_contributor", sectionTitle, showText, hideText, this.getTopContributors(payloadHolder.getTopContributors())));
        }
        if (CollectionUtils.isNotEmpty(payloadHolder.getTopViewers())) {
            sectionTitle = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.top.readers");
            messageData.getItems().add(new MessageData.Item("top_reader", sectionTitle, showText, hideText, this.getTopReaders(payloadHolder.getTopViewers())));
        }
        if (CollectionUtils.isNotEmpty(payloadHolder.getTopPages())) {
            sectionTitle = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.top.pages");
            messageData.getItems().add(new MessageData.Item("top_page", sectionTitle, showText, hideText, this.getTopContent(payloadHolder.getTopPages())));
        }
        if (CollectionUtils.isNotEmpty(payloadHolder.getTopBlogPosts())) {
            sectionTitle = this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.top.posts");
            messageData.getItems().add(new MessageData.Item("top_post", sectionTitle, showText, hideText, this.getTopContent(payloadHolder.getTopBlogPosts())));
        }
        Message message = TeamsPayloadUtils.createToggleableItemsMessage((MessageData)messageData);
        String payload = this.objectMapper.writeValueAsString((Object)message);
        log.debug("Progress statistics report payload: {}", (Object)payload);
        return payload;
    }

    private List<String> getTopContent(Set<StatisticsData> topContent) {
        String baseUrl = this.getBaseUrl();
        List<String> items = topContent.stream().map(data -> {
            String page = TeamsPayloadUtils.makeMicrosoftTeamsLink((String)data.getTitle(), (String)(baseUrl + data.getUrlPath()));
            return this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.top.content.stats", new Serializable[]{page, Integer.valueOf(data.getViewCount()), Integer.valueOf(data.getLikeCount()), Integer.valueOf(data.getCommentCount())});
        }).collect(Collectors.toList());
        return items;
    }

    private List<String> getTopReaders(Set<TopItemsDataHolder.TopViewer> topViewers) {
        List<String> items = topViewers.stream().map(data -> this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.top.readers.stats", new Serializable[]{data.getUser().getDisplayName(), Integer.valueOf(data.getContentCount())})).collect(Collectors.toList());
        return items;
    }

    private List<String> getTopContributors(Set<TopItemsDataHolder.TopContributor> topContributors) {
        List<String> items = topContributors.stream().map(data -> {
            int total = data.getContentCount() + data.getEditCount();
            return this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.top.contributor.stats", new Serializable[]{data.getUser().getDisplayName(), Integer.valueOf(total), Integer.valueOf(data.getContentCount()), Integer.valueOf(data.getEditCount())});
        }).collect(Collectors.toList());
        return items;
    }

    private List<String> getTopAuthors(Set<TopItemsDataHolder.TopAuthor> topAuthors) {
        List<String> items = topAuthors.stream().map(data -> {
            int total = data.getContentCount() + data.getCommentCount() + data.getLikeCount();
            return this.i18nResolver.getText("com.moveworkforward.confluence.microsoft.teams.report.top.author.stats", new Serializable[]{data.getUser().getDisplayName(), Integer.valueOf(total), Integer.valueOf(data.getContentCount()), Integer.valueOf(data.getCommentCount()), Integer.valueOf(data.getLikeCount())});
        }).collect(Collectors.toList());
        return items;
    }
}

